/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.annotation.processor.core.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.olingo.odata2.annotation.processor.core.util.AnnotationRuntimeException;

public class ClassHelper {
    private static final String JAR_FILE_ENDING = "jar";
    private static final String JAR_RESOURCE_SEPARATOR = "!";
    private static final char RESOURCE_SEPARATOR = '/';
    private static final char PACKAGE_SEPARATOR = '.';
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    private static final String CLASSFILE_ENDING = ".class";
    private static final FilenameFilter CLASSFILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(ClassHelper.CLASSFILE_ENDING);
        }
    };
    private static final FileFilter FOLDER_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    public static List<Class<?>> loadClasses(String packageToScan, ClassValidator cv) {
        return ClassHelper.loadClasses(packageToScan, CLASSFILE_FILTER, cv);
    }

    public static List<Class<?>> loadClasses(String packageToScan, FilenameFilter ff, ClassValidator cv) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URI uri = ClassHelper.getResourceUri(packageToScan, classLoader);
        File folder = new File(uri.getSchemeSpecificPart());
        Collection<String> fqnForClasses = folder.isDirectory() ? ClassHelper.getClassFqnFromDir(ff, folder, packageToScan) : (ClassHelper.isJarFile(uri) ? ClassHelper.getClassFqnFromJar(uri, packageToScan) : null);
        if (fqnForClasses == null || fqnForClasses.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList annotatedClasses = new ArrayList(fqnForClasses.size());
        for (String fqn : fqnForClasses) {
            try {
                Class<?> c = classLoader.loadClass(fqn);
                if (!cv.isClassValid(c)) continue;
                annotatedClasses.add(c);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalArgumentException("Exception during class loading of class '" + fqn + " from resource '" + uri + "'' with message '" + ex.getMessage() + "'.");
            }
        }
        return annotatedClasses;
    }

    private static URI getResourceUri(String packageToScan, ClassLoader classLoader) {
        String folderToScan = packageToScan.replace('.', '/');
        URL url = classLoader.getResource(folderToScan);
        if (url == null) {
            throw new IllegalArgumentException("No folder to scan found for package '" + packageToScan + "'.");
        }
        try {
            if (url.getPath().contains(" ")) {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath().replace(" ", "%20"));
            }
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid folder path for path URL '" + url + "' from thread context class loader.");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid folder path for path URL '" + url + "' from thread context class loader.");
        }
    }

    private static boolean isJarFile(URI uri) {
        return JAR_FILE_ENDING.equals(uri.getScheme());
    }

    private static Collection<String> getClassFqnFromDir(FilenameFilter ff, File folder, String packageToScan) {
        File[] subfolders;
        String[] classFilesForFolder;
        ArrayList<String> classFiles = new ArrayList<String>();
        for (String name : classFilesForFolder = folder.list(ff)) {
            String fqn = packageToScan + "." + name.substring(0, name.length() - CLASSFILE_ENDING.length());
            classFiles.add(fqn);
        }
        for (File file : subfolders = ClassHelper.listSubFolder(folder)) {
            classFiles.addAll(ClassHelper.getClassFqnFromDir(ff, file, packageToScan + '.' + file.getName()));
        }
        return classFiles;
    }

    private static Collection<String> getClassFqnFromJar(URI uri, String packageToScan) {
        String filepath = uri.getSchemeSpecificPart().substring(5);
        String[] split = filepath.split(JAR_RESOURCE_SEPARATOR);
        if (split.length != 2) {
            throw new IllegalArgumentException("Illegal jar file path '" + filepath + "'.");
        }
        String jarFilePath = split[0];
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jarFilePath);
            ArrayList<String> classFileNames = new ArrayList<String>();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                String name = je.getName();
                if (je.isDirectory() || !name.matches(".*" + packageToScan + ".*" + CLASSFILE_ENDING)) continue;
                String className = name.substring(0, name.length() - CLASSFILE_ENDING.length());
                classFileNames.add(className.replace('/', '.'));
            }
            ArrayList<String> arrayList = classFileNames;
            return arrayList;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Exception during class loading from path '" + jarFilePath + "' with message '" + e.getMessage() + "'.");
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error during close of jar file: " + jarFile.getName() + "", e);
                }
            }
        }
    }

    public static Class<?> getFieldType(Field field) {
        if (field.getType().isArray() || Collection.class.isAssignableFrom(field.getType())) {
            return (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        }
        return field.getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFieldValue(Object instance, Field field) {
        try {
            Field field2 = field;
            synchronized (field2) {
                boolean access = field.isAccessible();
                field.setAccessible(true);
                Object value = field.get(instance);
                field.setAccessible(access);
                return value;
            }
        }
        catch (IllegalArgumentException ex) {
            throw new AnnotationRuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new AnnotationRuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFieldValue(Object instance, Field field, Object value) {
        try {
            Field field2 = field;
            synchronized (field2) {
                boolean access = field.isAccessible();
                field.setAccessible(true);
                field.set(instance, value);
                field.setAccessible(access);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new AnnotationRuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new AnnotationRuntimeException(ex);
        }
    }

    private static File[] listSubFolder(File folder) {
        File[] subfolders = folder.listFiles(FOLDER_FILTER);
        if (subfolders == null) {
            return EMPTY_FILE_ARRAY;
        }
        return subfolders;
    }

    public static interface ClassValidator {
        public boolean isClassValid(Class<?> var1);
    }
}

