package cronapp.reports.j4c.dataset.jdbc;

public class ForeignKey extends DatabaseObject {
  
  private final ColumnsReference source;
  private final ColumnsReference target;
  
  public ForeignKey(String name, ColumnsReference source, ColumnsReference target) {
    super(name);
    this.source = source;
    this.target = target;
  }
  
  public ColumnsReference getSource() {
    return source;
  }
  
  public ColumnsReference getTarget() {
    return target;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    ForeignKey that = (ForeignKey)o;
    if(source != null ? !source.equals(that.source) : that.source != null)
      return false;
    return target != null ? target.equals(that.target) : that.target == null;
  }
  
  @Override
  public int hashCode() {
    int result = source != null ? source.hashCode() : 0;
    result = 31 * result + (target != null ? target.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "ForeignKey{" + "source=" + source + ", target=" + target + '}';
  }
}
