package cronapp.reports.j4c;

import java.io.Serializable;

/**
 * Representa uma coluna do relatório.
 *
 * Created by arthemus on 10/06/16.
 */
public class J4CField implements Serializable, Cloneable {
  
  private Class<?> type;
  
  private J4CText text;
  
  private J4CText title;
  
  private J4CGroup group;
  
  private J4CSummary summary;
  
  public J4CField() {
    this.type = String.class;
    this.text = new J4CText();
    this.title = new J4CText();
  }
  
  public Class<?> getType() {
    return type;
  }
  
  public void setType(Class<?> type) {
    this.type = type;
  }
  
  public J4CText getText() {
    return text;
  }
  
  public void setText(J4CText text) {
    this.text = text;
  }
  
  public J4CText getTitle() {
    return title;
  }
  
  public void setTitle(J4CText title) {
    this.title = title;
  }
  
  public J4CGroup getGroup() {
    return group;
  }
  
  public void setGroup(J4CGroup group) {
    this.group = group;
  }
  
  public J4CSummary getSummary() {
    return summary;
  }
  
  public void setSummary(J4CSummary summary) {
    this.summary = summary;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CField j4CField = (J4CField)o;
    if(type != null ? !type.equals(j4CField.type) : j4CField.type != null)
      return false;
    if(text != null ? !text.equals(j4CField.text) : j4CField.text != null)
      return false;
    if(title != null ? !title.equals(j4CField.title) : j4CField.title != null)
      return false;
    if(group != null ? !group.equals(j4CField.group) : j4CField.group != null)
      return false;
    return summary != null ? summary.equals(j4CField.summary) : j4CField.summary == null;
  }
  
  @Override
  public int hashCode() {
    int result = type != null ? type.hashCode() : 0;
    result = 31 * result + (text != null ? text.hashCode() : 0);
    result = 31 * result + (title != null ? title.hashCode() : 0);
    result = 31 * result + (group != null ? group.hashCode() : 0);
    result = 31 * result + (summary != null ? summary.hashCode() : 0);
    return result;
  }

  @Override
  public String toString() {
    return "J4CField{" +
            "type=" + type +
            ", text=" + text +
            ", title=" + title +
            ", group=" + group +
            ", summary=" + summary +
            '}';
  }

  @Override
  public J4CField clone() {
    try {
      J4CField clone = (J4CField)super.clone();
      clone.setText(this.text.clone());
      clone.setSummary(this.summary.clone());
      clone.setTitle(this.title.clone());
      clone.setGroup(this.group.clone());
      return clone;
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  
}
