package cronapp.reports.j4c.dataset.jdbc;

import java.util.ArrayList;
import java.util.List;

/**
 * @author elton.nascimento on 24/07/18
 */
public enum SqlOperatorType {

  EQUAL("="), NOTEQUAL("<>"), GREATER(">"), GREATEREQUAL(">="), MINOR("<"), MINOR_EQUAL("<="), LIKE("LIKE"), BETWEEN("BETWEEN"), IN("IN");

  private String description;

  SqlOperatorType(String description) {
    this.description = description;
  }

  public String getDescription() {
    return description;
  }

  public static List<String> getSqlTypesDescription() {
    List<String> list = new ArrayList<>();
    for (SqlOperatorType sql : SqlOperatorType.values()) {
      list.add(sql.getDescription());
    }
    return list;
  }
}
