package cronapp.reports.j4c.dataset.jdbc;

class DataSourceConfigDefault implements DataSourceConfig {
  
  private String driverClassName;
  private String jdbcUrl;
  private String username;
  private String password;
  
  @Override
  public String getDriverClassName() {
    return driverClassName;
  }
  
  public void setDriverClassName(String driverClassName) {
    this.driverClassName = driverClassName;
  }
  
  @Override
  public String getJdbcUrl() {
    return jdbcUrl;
  }
  
  public void setJdbcUrl(String jdbcUrl) {
    this.jdbcUrl = jdbcUrl;
  }
  
  @Override
  public String getUsername() {
    return username;
  }
  
  public void setUsername(String username) {
    this.username = username;
  }
  
  @Override
  public String getPassword() {
    return password;
  }
  
  public void setPassword(String password) {
    this.password = password;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    DataSourceConfigDefault that = (DataSourceConfigDefault)o;
    if(driverClassName != null ? !driverClassName.equals(that.driverClassName) : that.driverClassName != null)
      return false;
    if(jdbcUrl != null ? !jdbcUrl.equals(that.jdbcUrl) : that.jdbcUrl != null)
      return false;
    if(username != null ? !username.equals(that.username) : that.username != null)
      return false;
    return password != null ? password.equals(that.password) : that.password == null;
  }
  
  @Override
  public int hashCode() {
    int result = driverClassName != null ? driverClassName.hashCode() : 0;
    result = 31 * result + (jdbcUrl != null ? jdbcUrl.hashCode() : 0);
    result = 31 * result + (username != null ? username.hashCode() : 0);
    result = 31 * result + (password != null ? password.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "DataSourceConfigDefault{" + "driverClassName='" + driverClassName + '\'' + ", jdbcUrl='" + jdbcUrl + '\'' +
            ", username='" + username + '\'' + ", password='" + password + '\'' + '}';
  }
}
