package cronapp.reports.j4c.charts;

import net.sf.jasperreports.engine.JRChart;

/**
 * Referência ao gráfico de pizza.
 *
 * Created by arthemus on 13/07/16.
 */
public class J4CPieChart extends J4CAbstractChart {
  
  private String key;
  private String serie;
  
  public J4CPieChart() {
    super();
  }
  
  public String getKey() {
    return key;
  }
  
  public void setKey(String key) {
    this.key = key;
  }
  
  public String getSerie() {
    return serie;
  }
  
  public void setSerie(String serie) {
    this.serie = serie;
  }
  
  @Override
  public byte getJRType() {
    return JRChart.CHART_TYPE_PIE;
  }
  
  @Override
  public String getImagePath() {
    return "jasperreports/charts/pie.png";
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CPieChart that = (J4CPieChart)o;
    if(key != null ? !key.equals(that.key) : that.key != null)
      return false;
    return serie != null ? serie.equals(that.serie) : that.serie == null;
  }
  
  @Override
  public int hashCode() {
    int result = key != null ? key.hashCode() : 0;
    result = 31 * result + (serie != null ? serie.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "J4CPieChart{" + "key=" + key + ", serie=" + serie + '}';
  }
  
  @Override
  public J4CPieChart clone() {
    try {
      return (J4CPieChart)super.clone();
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
}
