package cronapp.reports.j4c;

import java.io.Serializable;

import cronapp.reports.j4c.commons.J4CPosition;
import net.sf.jasperreports.engine.type.ScaleImageEnum;

/**
 * Logotipo de um determinado relatório.
 *
 * Created by arthemus on 11/07/16.
 */
public class J4CImage implements Serializable, Cloneable {
  
  private String path;
  
  private int width;
  
  private int height;
  
  private J4CPosition position;
  
  private boolean repeatEachPage;
  
  private ScaleImageEnum imageScale;
  
  public J4CImage() {
    this.width = 100;
    this.height = 100;
    this.position = J4CPosition.LEFT;
    this.repeatEachPage = false;
    this.imageScale = ScaleImageEnum.REAL_SIZE;
  }
  
  public String getPath() {
    return path;
  }
  
  public void setPath(String path) {
    this.path = path;
  }
  
  public int getWidth() {
    return width;
  }
  
  public void setWidth(int width) {
    this.width = width;
  }
  
  public int getHeight() {
    return height;
  }
  
  public void setHeight(int height) {
    this.height = height;
  }
  
  public J4CPosition getPosition() {
    return position;
  }
  
  public void setPosition(J4CPosition position) {
    this.position = position;
  }
  
  public boolean isRepeatEachPage() {
    return repeatEachPage;
  }
  
  public void setRepeatEachPage(boolean repeatEachPage) {
    this.repeatEachPage = repeatEachPage;
  }
  
  public ScaleImageEnum getImageScale() {
    return imageScale;
  }
  
  public void setImageScale(ScaleImageEnum imageScale) {
    this.imageScale = imageScale;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CImage j4CImage = (J4CImage)o;
    if(width != j4CImage.width)
      return false;
    if(height != j4CImage.height)
      return false;
    if(repeatEachPage != j4CImage.repeatEachPage)
      return false;
    if(path != null ? !path.equals(j4CImage.path) : j4CImage.path != null)
      return false;
    if(position != j4CImage.position)
      return false;
    return imageScale == j4CImage.imageScale;
  }
  
  @Override
  public int hashCode() {
    int result = path != null ? path.hashCode() : 0;
    result = 31 * result + width;
    result = 31 * result + height;
    result = 31 * result + (position != null ? position.hashCode() : 0);
    result = 31 * result + (repeatEachPage ? 1 : 0);
    result = 31 * result + (imageScale != null ? imageScale.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "J4CImage{" + "path='" + path + '\'' + '}';
  }
  
  @Override
  public J4CImage clone() {
    try {
      return (J4CImage)super.clone();
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
}
