package cronapp.reports.j4c;

import java.io.Serializable;

/**
 * Definições da fonte de um componente de texto do relatório.
 *
 * Created by arthemus on 07/06/16.
 */
public class J4CFont implements Serializable, Cloneable {
  
  private String name;
  
  private int size;
  
  private boolean bold;
  
  private boolean italic;
  
  private boolean underline;
  
  public J4CFont() {
    this.name = "Arial";
    this.size = 10;
    this.bold = false;
    this.italic = false;
    this.underline = false;
  }
  
  public String getName() {
    return name;
  }
  
  public void setName(String name) {
    this.name = name;
  }
  
  public int getSize() {
    return size;
  }
  
  public void setSize(int size) {
    this.size = size;
  }
  
  public boolean isBold() {
    return bold;
  }
  
  public void setBold(boolean bold) {
    this.bold = bold;
  }
  
  public boolean isItalic() {
    return italic;
  }
  
  public void setItalic(boolean italic) {
    this.italic = italic;
  }
  
  public boolean isUnderline() {
    return underline;
  }
  
  public void setUnderline(boolean underline) {
    this.underline = underline;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CFont j4CFont = (J4CFont)o;
    if(size != j4CFont.size)
      return false;
    if(bold != j4CFont.bold)
      return false;
    if(italic != j4CFont.italic)
      return false;
    if(underline != j4CFont.underline)
      return false;
    return name != null ? name.equals(j4CFont.name) : j4CFont.name == null;
  }
  
  @Override
  public int hashCode() {
    int result = name != null ? name.hashCode() : 0;
    result = 31 * result + size;
    result = 31 * result + (bold ? 1 : 0);
    result = 31 * result + (italic ? 1 : 0);
    result = 31 * result + (underline ? 1 : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "J4CFont{" + "name='" + name + '\'' + '}';
  }
  
  @Override
  public J4CFont clone() {
    try {
      return (J4CFont)super.clone();
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  
}
