package cronapp.reports.commons;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import cronapp.reports.j4c.J4CChart;
import cronapp.reports.j4c.commons.J4CGsonAdapter;

/**
 * Classe responsavel por servir de container para o objeto {@link Gson}.
 * A instanciação da classe {@link Gson} é bem custosa e demorada, a ideia dessa implementação singleto é agilizar o
 * processo de utilização da classe Gson para serializar objetos Json.
 * 
 * Created by arthemus on 05/05/16.
 */
public enum GsonSingleton implements Bean<Gson> {
  
  INSTANCE {
    
    private final Gson gson = new GsonBuilder()
            .registerTypeAdapterFactory(new ClassTypeAdapterFactory())
            .registerTypeAdapter(J4CChart.class, new J4CGsonAdapter())
            .create();
    
    /**
     * Caso deseja-se gerar o json formatado, chamar o método {@link GsonBuilder#setPrettyPrinting()}
     */
    @Override
    public Gson get() {
      return this.gson;
    }
    
    @Override
    public void set(Gson object) {
      // NoCommand
    }
  }
}
