/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c.export;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import cronapp.reports.j4c.J4CObject;
import cronapp.reports.j4c.export.DynamicReportExport;
import cronapp.reports.j4c.export.J4CExport;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

public class JrxmlExport
implements J4CExport<String> {
    private final J4CObject j4CObject;
    private final Connection connection;

    JrxmlExport(J4CObject j4CObject, Connection connection) {
        this.j4CObject = j4CObject;
        this.connection = connection;
    }

    @Override
    public String get() {
        DynamicReportExport dynamicReportExport = this.j4CObject.build().toDynamicReport(this.connection);
        try {
            DynamicReport dynamicReport = dynamicReportExport.get();
            Map<String, Object> parameters = this.j4CObject.getParametersDefaultValue();
            String jrxml = DynamicJasperHelper.generateJRXML((DynamicReport)dynamicReport, (LayoutManager)new ClassicLayoutManager(), parameters, (String)"UTF-8");
            jrxml = jrxml.replaceAll("scriptletClass=\"ar.com.fdvs.dj.core.DJDefaultScriptlet\"", "");
            jrxml = jrxml.replace("<![CDATA[\"$P{", "<![CDATA[$P{").replace("}\"]]>", "}]]>");
            ByteArrayInputStream contentStream = new ByteArrayInputStream(jrxml.getBytes(StandardCharsets.UTF_8));
            JasperDesign jasperDesign = JRXmlLoader.load((InputStream)contentStream);
            this.j4CObject.getParameters().forEach(parameter -> {
                JRDesignExpression designExpression = new JRDesignExpression();
                JRDesignParameter designParameter = new JRDesignParameter();
                designParameter.setName(parameter.getName());
                designParameter.setDefaultValueExpression((JRExpression)designExpression);
                JRParameter jrParameter = (JRParameter)jasperDesign.getParametersMap().get(designParameter.getName());
                if (jrParameter == null) {
                    try {
                        jasperDesign.addParameter((JRParameter)designParameter);
                    }
                    catch (JRException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    ((JRDesignParameter)jrParameter).setDefaultValueExpression((JRExpression)designExpression);
                }
            });
            return JasperCompileManager.writeReportToXml((JRReport)jasperDesign);
        }
        catch (JRException e) {
            throw new RuntimeException(e);
        }
    }
}

