package cronapp.reports.j4c.dataset.jdbc;

public class PrimaryKey extends DatabaseObject {
  
  private final ColumnsReference source;
  
  public PrimaryKey(String name, ColumnsReference source) {
    super(name);
    this.source = source;
  }
  
  public ColumnsReference getSource() {
    return source;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    PrimaryKey that = (PrimaryKey)o;
    return source != null ? source.equals(that.source) : that.source == null;
  }
  
  @Override
  public int hashCode() {
    return source != null ? source.hashCode() : 0;
  }
  
  @Override
  public String toString() {
    return "PrimaryKey{" + "source=" + source + '}';
  }
}
