package cronapp.reports.j4c.dataset.jdbc;

public class ColumnsReference {
  
  private String tableName;
  private String columnName;
  
  public ColumnsReference(String tableName, String columnName) {
    this.tableName = tableName;
    this.columnName = columnName;
  }
  
  public String getTableName() {
    return tableName;
  }
  
  public void setTableName(String tableName) {
    this.tableName = tableName;
  }
  
  public String getColumnName() {
    return columnName;
  }
  
  public void setColumnName(String columnName) {
    this.columnName = columnName;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    ColumnsReference that = (ColumnsReference)o;
    if(tableName != null ? !tableName.equals(that.tableName) : that.tableName != null)
      return false;
    return columnName != null ? columnName.equals(that.columnName) : that.columnName == null;
  }
  
  @Override
  public int hashCode() {
    int result = tableName != null ? tableName.hashCode() : 0;
    result = 31 * result + (columnName != null ? columnName.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "ColumnsReference{" + "tableName='" + tableName + '\'' + ", columnName='" + columnName + '\'' + '}';
  }
}
