package cronapp.reports.j4c.export;

import cronapp.reports.j4c.J4CObject;

import java.sql.Connection;

/**
 * Classe responsável por instanciar as implementações de exportação do relatório para diferentes formatos.
 *
 * Created by arthemus on 08/06/16.
 */
public class ReportMaker {
  
  private final J4CObject j4CObject;
  
  public ReportMaker(J4CObject j4CObject) {
    this.j4CObject = j4CObject;
  }
  
  /**
   * @return Objeto capaz de exportar o {@link this#j4CObject} no formato JSON.
   */
  public JsonExport toJson() {
    return new JsonExport(this.j4CObject);
  }
  
  /**
   * @return Objeto capaz de exportar o {@link this#j4CObject} para uma instância da classe {@link DynamicReportExport}
   *         onde as informações do relatório serão processadas.
   */
  public DynamicReportExport toDynamicReport(Connection connection) {
    return new DynamicReportExport(this.j4CObject, connection);
  }
  
  /**
   * @return Objeto capaz de exportar o {@link this#j4CObject} no formato JRXML.
   */
  public JrxmlExport toJrxml(Connection connection) {
    return new JrxmlExport(this.j4CObject, connection);
  }
  
  /**
   * @return Objeto capaz de exportar o {@link this#j4CObject} no formato Base64, para ser usado no processo de
   *         impressão.
   */
  public Base64Export toBase64(Connection connection) {
    return new Base64Export(this.j4CObject, connection);
  }
  
}
