package cronapp.reports.j4c.dataset;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Representação de uma tabela do banco de dados.
 *
 * Created by arthemus on 19/07/16.
 */
public class J4CTable implements Serializable, Comparable<J4CTable>, Cloneable {
  
  private String name;
  
  private String as;
  
  private transient List<J4CColumn> columns;
  
  public J4CTable() {
  }
  
  J4CTable(String name) {
    this.name = name;
  }
  
  public J4CTable(String name, String as) {
    this.name = name;
    this.as = as;
  }
  
  public String getName() {
    return name;
  }
  
  public void setName(String name) {
    this.name = name;
  }
  
  public String getAs() {
    return as;
  }
  
  public void setAs(String as) {
    this.as = as;
  }
  
  public List<J4CColumn> getColumns() {
    if(columns == null)
      this.columns = new ArrayList<>();
    return columns;
  }
  
  public void setColumns(List<J4CColumn> columns) {
    this.columns = columns;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CTable j4CTable = (J4CTable)o;
    return name != null ? name.equals(j4CTable.name)
            : j4CTable.name == null && (as != null ? as.equals(j4CTable.as) : j4CTable.as == null);
  }
  
  @Override
  public int hashCode() {
    int result = name != null ? name.hashCode() : 0;
    result = 31 * result + (as != null ? as.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "J4CTable{" + "name='" + name + '\'' + '}';
  }
  
  @Override
  public J4CTable clone() {
    try {
      return (J4CTable)super.clone();
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  
  @Override
  public int compareTo(J4CTable o) {
    return this.getName().compareTo(o.getName());
  }
  
}
