package cronapp.reports.j4c.dataset;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

import org.bouncycastle.asn1.tsp.TimeStampReq;

import cronapp.reports.j4c.dataset.jdbc.JDBC;

/**
 * Representação de uma coluna da tabela utilizada no dataset do relatório.
 *
 * Created by arthemus on 19/07/16.
 */
public class J4CColumn implements Serializable, Cloneable {
  
  private J4CTable parent;
  
  private String name;
  
  private String as;
  
  private String type;
  
  public J4CColumn() {
  }
  
  public J4CColumn(J4CTable parent, String name) {
    this.parent = parent;
    this.name = name;
  }
  
  public J4CColumn(J4CTable parent, String name, String type) {
    this.parent = parent;
    this.name = name;
    this.type = type;
  }
  
  public J4CColumn(J4CTable parent, String name, String as, String type) {
    this.parent = parent;
    this.name = name;
    this.as = as;
    this.type = type;
  }
  
  public J4CColumn(String name, String as, String type) {
    this.name = name;
    this.as = as;
    this.type = type;
  }
  
  public J4CTable getParent() {
    return parent;
  }
  
  public void setParent(J4CTable parent) {
    this.parent = parent;
  }
  
  public String getName() {
    return name;
  }
  
  public void setName(String name) {
    this.name = name;
  }
  
  public String getAs() {
    return as;
  }
  
  public void setAs(String as) {
    this.as = as;
  }
  
  public String getType() {
    return type;
  }
  
  public String getTypeJava() {
    return JDBC.getJavaType(this.type);
  }
  
  public Class<?> getTypeClass() {
	  
    switch(this.type) {
      case "java.lang.Boolean":
        return Boolean.class;
      case "java.lang.Short":
        return Short.class;
      case "java.lang.Integer":
        return Integer.class;
      case "java.lang.Long":
        return Long.class;
      case "java.lang.Float":
        return Float.class;
      case "java.lang.Double":	
        return Double.class;
      case "java.sql.Timestamp":
    	  return Timestamp.class;
      case "java.sql.Time":
    	  return Time.class;
      case "java.sql.Date":
    	  return Date.class;
      case "java.math.BigDecimal":
          return BigDecimal.class;
      case "java.lang.String":
    	  return String.class;
      default:
        return Object.class;
    }
  }
  
  public void setType(String type) {
    this.type = type;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CColumn j4CColumn = (J4CColumn)o;
    if(parent != null ? !parent.equals(j4CColumn.parent) : j4CColumn.parent != null)
      return false;
    if(name != null ? !name.equals(j4CColumn.name) : j4CColumn.name != null)
      return false;
    if(as != null ? !as.equals(j4CColumn.as) : j4CColumn.as != null)
      return false;
    return type != null ? type.equals(j4CColumn.type) : j4CColumn.type == null;
  }
  
  @Override
  public int hashCode() {
    int result = parent != null ? parent.hashCode() : 0;
    result = 31 * result + (name != null ? name.hashCode() : 0);
    result = 31 * result + (as != null ? as.hashCode() : 0);
    result = 31 * result + (type != null ? type.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "J4CColumn{" + "parent=" + parent + ", name='" + name + '\'' + ", as='" + as + '\'' + ", type='" + type +
            '\'' + '}';
  }
  
  @Override
  public J4CColumn clone() {
    try {
      return (J4CColumn)super.clone();
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  
}
