package cronapp.reports.j4c.charts;

import cronapp.reports.j4c.J4CChart;
import cronapp.reports.j4c.commons.J4CChartPosition;

/**
 * Caracteristicas básicas e comuns a todos os gráficos.
 *
 * Created by arthemus on 13/07/16.
 */
public abstract class J4CAbstractChart implements J4CChart {
  
  private int height;
  private int width;
  private boolean centered;
  private J4CChartPosition j4CChartPosition;
  
  protected J4CAbstractChart() {
    this.height = 500;
    this.width = 250;
    this.centered = true;
    this.j4CChartPosition = J4CChartPosition.HEADER;
  }
  
  @Override
  public void setHeight(int height) {
    this.height = height;
  }
  
  @Override
  public int getHeight() {
    return this.height;
  }
  
  @Override
  public void setWidth(int width) {
    this.width = width;
  }
  
  @Override
  public int getWidth() {
    return this.width;
  }
  
  @Override
  public void setCentered(boolean centered) {
    this.centered = centered;
  }
  
  @Override
  public boolean isCentered() {
    return this.centered;
  }
  
  @Override
  public void setPosition(J4CChartPosition j4CChartPosition) {
    this.j4CChartPosition = j4CChartPosition;
  }
  
  @Override
  public J4CChartPosition getPosition() {
    return this.j4CChartPosition;
  }
}
