package cronapp.reports.j4c.dataset.jdbc;

public class Column {
  
  private String name;
  private String type;
  private int ordinalPosition;
  private Boolean isNullable;
  
  public Column(int ordinalPosition, String name, String type) {
    this(ordinalPosition, name, type, null);
  }
  
  public Column(int ordinalPosition, String name, String type, Boolean isNullable) {
    this.ordinalPosition = ordinalPosition;
    this.name = name;
    this.type = type;
    this.isNullable = isNullable;
  }
  
  public String getName() {
    return name;
  }
  
  public void setName(String name) {
    this.name = name;
  }
  
  public String getType() {
    return type;
  }
  
  public void setType(String type) {
    this.type = type;
  }
  
  public int getOrdinalPosition() {
    return ordinalPosition;
  }
  
  public void setOrdinalPosition(int ordinalPosition) {
    this.ordinalPosition = ordinalPosition;
  }
  
  public void setNullable(Boolean nullable) {
    isNullable = nullable;
  }
  
  public Boolean isNullable(boolean assumption) {
    return isNullable == null ? assumption : isNullable;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    Column column = (Column)o;
    if(ordinalPosition != column.ordinalPosition)
      return false;
    if(name != null ? !name.equals(column.name) : column.name != null)
      return false;
    if(type != null ? !type.equals(column.type) : column.type != null)
      return false;
    return isNullable != null ? isNullable.equals(column.isNullable) : column.isNullable == null;
    
  }
  
  @Override
  public int hashCode() {
    int result = name != null ? name.hashCode() : 0;
    result = 31 * result + (type != null ? type.hashCode() : 0);
    result = 31 * result + ordinalPosition;
    result = 31 * result + (isNullable != null ? isNullable.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "Column{" + "name='" + name + '\'' + ", type='" + type + '\'' + ", ordinalPosition=" + ordinalPosition +
            ", isNullable=" + isNullable + '}';
  }
}
