package cronapp.reports.j4c;

import java.io.Serializable;

import cronapp.reports.j4c.commons.J4CPageFormat;
import cronapp.reports.j4c.commons.J4CPageLeaf;

/**
 * Definições da página do relatório como valores de margem, espaçamento e formato.
 *
 * Created by arthemus on 12/07/16.
 */
public class J4CPage implements Serializable, Cloneable {
  
  private int topMargin;
  
  private int bottomMargin;
  
  private int leftMargin;
  
  private int rightMargin;
  
  private int lineSpace;
  
  private J4CPageLeaf leaf;
  
  private J4CPageFormat format;
  
  public J4CPage() {
    this.topMargin = 20;
    this.bottomMargin = 20;
    this.leftMargin = 20;
    this.rightMargin = 20;
    this.lineSpace = 0;
    this.leaf = J4CPageLeaf.A4;
    this.format = J4CPageFormat.PORTRAIT;
  }
  
  public int getTopMargin() {
    return topMargin;
  }
  
  public void setTopMargin(int topMargin) {
    this.topMargin = topMargin;
  }
  
  public int getBottomMargin() {
    return bottomMargin;
  }
  
  public void setBottomMargin(int bottomMargin) {
    this.bottomMargin = bottomMargin;
  }
  
  public int getLeftMargin() {
    return leftMargin;
  }
  
  public void setLeftMargin(int leftMargin) {
    this.leftMargin = leftMargin;
  }
  
  public int getRightMargin() {
    return rightMargin;
  }
  
  public void setRightMargin(int rightMargin) {
    this.rightMargin = rightMargin;
  }
  
  public J4CPageFormat getFormat() {
    return format;
  }
  
  public void setFormat(J4CPageFormat format) {
    this.format = format;
  }
  
  public J4CPageLeaf getLeaf() {
    return leaf;
  }
  
  public void setLeaf(J4CPageLeaf leaf) {
    this.leaf = leaf;
  }
  
  public int getLineSpace() {
    return lineSpace;
  }
  
  public void setLineSpace(int lineSpace) {
    this.lineSpace = lineSpace;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CPage j4CPage = (J4CPage)o;
    if(topMargin != j4CPage.topMargin)
      return false;
    if(bottomMargin != j4CPage.bottomMargin)
      return false;
    if(leftMargin != j4CPage.leftMargin)
      return false;
    if(rightMargin != j4CPage.rightMargin)
      return false;
    if(lineSpace != j4CPage.lineSpace)
      return false;
    if(leaf != j4CPage.leaf)
      return false;
    return format == j4CPage.format;
  }
  
  @Override
  public int hashCode() {
    int result = topMargin;
    result = 31 * result + bottomMargin;
    result = 31 * result + leftMargin;
    result = 31 * result + rightMargin;
    result = 31 * result + lineSpace;
    result = 31 * result + (leaf != null ? leaf.hashCode() : 0);
    result = 31 * result + (format != null ? format.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "J4CPage{" + "topMargin=" + topMargin + ", bottomMargin=" + bottomMargin + ", leftMargin=" + leftMargin +
            ", rightMargin=" + rightMargin + ", lineSpace=" + lineSpace + ", leaf=" + leaf + ", format=" + format + '}';
  }
  
  @Override
  public J4CPage clone() {
    try {
      return (J4CPage)super.clone();
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  
}
