package cronapp.reports.j4c;

import java.awt.*;
import java.io.Serializable;
import java.util.stream.Stream;

import cronapp.reports.j4c.commons.J4CBorderWidth;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBoxPen;
import net.sf.jasperreports.engine.type.LineStyleEnum;

/**
 * Representação da borda de um componente.
 *
 * Created by arthemus on 08/07/16.
 */
public class J4CBorder implements Serializable, Cloneable {
  
  private LineStyleEnum lineStyle;
  
  private J4CBorderWidth width;
  
  private Color color;
  
  public J4CBorder() {
    this.lineStyle = LineStyleEnum.SOLID;
    this.width = J4CBorderWidth.NONE;
    this.color = Color.BLACK;
  }

  public J4CBorder(JRPen jrPen) {
    this.lineStyle = jrPen.getLineStyleValue();
    this.width = J4CBorderWidth.getByWidth(jrPen.getLineWidth());
    this.color = jrPen.getLineColor();
  }
  
  public LineStyleEnum getLineStyle() {
    return lineStyle;
  }
  
  public void setLineStyle(LineStyleEnum lineStyle) {
    this.lineStyle = lineStyle;
  }
  
  public J4CBorderWidth getWidth() {
    return width;
  }
  
  public void setWidth(J4CBorderWidth width) {
    this.width = width;
  }
  
  public Color getColor() {
    return color;
  }
  
  public void setColor(Color color) {
    this.color = color;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CBorder j4CBorder = (J4CBorder)o;
    if(lineStyle != j4CBorder.lineStyle)
      return false;
    if(width != j4CBorder.width)
      return false;
    return color != null ? color.equals(j4CBorder.color) : j4CBorder.color == null;
  }
  
  @Override
  public int hashCode() {
    int result = lineStyle != null ? lineStyle.hashCode() : 0;
    result = 31 * result + (width != null ? width.hashCode() : 0);
    result = 31 * result + (color != null ? color.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "J4CBorder{" + "lineStyle=" + lineStyle + ", width=" + width + ", color=" + color + '}';
  }
  
  @Override
  public J4CBorder clone() {
    try {
      return (J4CBorder)super.clone();
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  
  /**
   *
   * @return Retorna um array com todas as opções de estilo para linhas.
   */
  public static String[] lineStyles() {
    return Stream.of(LineStyleEnum.values()).map(LineStyleEnum::getName).toArray(String[]::new);
  }

  /**
   * Atualiza um objeto do tipo {@link JRBoxPen} nativo da biblioteca Jasperreports.
   * 
   * @param pen
   *          Objeto a ser atualizado.
   */
  public void buildPen(JRPen pen) {
    if(pen != null) {
      pen.setLineColor(this.getColor());
      pen.setLineStyle(this.getLineStyle());
      pen.setLineWidth(this.getWidth().getWidth());
    }
  }

}
