package cronapp.reports.commons;

import java.util.Observer;
import java.util.function.Consumer;

/**
 * Classe auxiliar para permitir um log de informações simples entre processamentos paralelos com base no padrão
 * Observer.
 *
 * @author arthemus
 * @since 23/08/17
 * @see Observer
 */
public class AutoObserver<T> {
  
  private final Consumer<T> consumer;
  
  public AutoObserver(Consumer<T> consumer) {
    this.consumer = consumer;
  }
  
  public void setValue(T value) {
    this.consumer.accept(value);
  }
  
}
