package cronapp.reports.j4c.dataset;

import java.io.Serializable;

import cronapp.reports.j4c.commons.J4CMatchOperator;

/**
 * Implementação da operação Join para unir duas tabelas na query.
 * 
 * Created by Arthemus on 20/09/2016.
 */
public class J4CJoin implements Serializable, Cloneable {
  
  private J4CColumn right;
  
  private J4CMatchOperator operator;
  
  private J4CColumn left;
  
  public J4CJoin() {
  }
  
  public J4CJoin(J4CColumn right, J4CMatchOperator operator, J4CColumn left) {
    this.right = right;
    this.operator = operator;
    this.left = left;
  }
  
  public J4CColumn getLeft() {
    return left;
  }
  
  public void setLeft(J4CColumn left) {
    this.left = left;
  }
  
  public J4CMatchOperator getOperator() {
    return operator;
  }
  
  public void setOperator(J4CMatchOperator operator) {
    this.operator = operator;
  }
  
  public J4CColumn getRight() {
    return right;
  }
  
  public void setRight(J4CColumn right) {
    this.right = right;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CJoin j4CJoin = (J4CJoin)o;
    if(left != null ? !left.equals(j4CJoin.left) : j4CJoin.left != null)
      return false;
    if(operator != j4CJoin.operator)
      return false;
    return right != null ? right.equals(j4CJoin.right) : j4CJoin.right == null;
  }
  
  @Override
  public int hashCode() {
    int result = left != null ? left.hashCode() : 0;
    result = 31 * result + (operator != null ? operator.hashCode() : 0);
    result = 31 * result + (right != null ? right.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "J4CJoin{ " +
            left.getParent().getName() + "." + left.getName() +
            " " + operator.getOperator() + " " +
            right.getParent().getName() + "." + right.getName() +
            " }";
  }
  
  @Override
  public J4CJoin clone() {
    try {
      J4CJoin clone = (J4CJoin)super.clone();
      clone.setLeft(left.clone());
      clone.setOperator(operator);
      clone.setRight(right.clone());
      return clone;
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  
}
