package cronapp.reports.j4c.commons;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * Utilitários para o módulo J4C.
 * 
 * Created by Arthemus on 29/09/2016.
 */
public class J4CUtils {
  
  private static final HashMap<String, Object> defaultTypes = new HashMap<>();
  
  static {
    defaultTypes.put(String.class.getName(), "");
    defaultTypes.put(Integer.class.getName(), 0);
    defaultTypes.put(Long.class.getName(), 0L);
    defaultTypes.put(Float.class.getName(), 0F);
    defaultTypes.put(Double.class.getName(), 0D);
    defaultTypes.put(Boolean.class.getName(), Boolean.FALSE);
    defaultTypes.put(Date.class.getName(), new Date());
    defaultTypes.put(List.class.getName(), new ArrayList<>());
  }
  
  /**
   * Obtem o valor padrão de um determinado tipo Java.
   * 
   * @param type
   *          Nome absoluto de uma classe.
   * @return Valor padrão desse tipo.
   */
  public static Object defaultValueBy(String type) {
    return defaultTypes.get(type);
  }

  /**
   * Ajusta uma query sql para contem o parâmetro {@link J4CConstants#DATA_LIMIT} e a execução respeitar o limite
   * informado.
   * 
   * @param connection
   *          Conexão com o banco.
   * @param query
   *          Query sql a ser modificada.
   * @return Nova query sql com o parâmetro atribuido.
   */
  public static String getPrepareSQLQuery(Connection connection, String query) throws SQLException {
    if(connection == null)
      return query;
    if("Oracle".equals(connection.getMetaData().getDatabaseProductName())) {
      if(query.toLowerCase().contains("where"))
        return query.concat("\nAND (ROWNUM <= $P{DATA_LIMIT})");
      else
        return query.concat("\nWHERE (ROWNUM <= $P{DATA_LIMIT})");
    }
    else {
      if(!query.toLowerCase().contains("limit"))
        return query.concat("\nlimit $P{DATA_LIMIT}");
      return query;
    }
  }

  public static Object checkValue(String type, Object value) {
    if(Integer.class.getName().equals(type)) {
      if(value instanceof Double) {
        Double doubleValue = (Double)value;
        int intValue = doubleValue.intValue();
        if(intValue == doubleValue)
          return intValue;
      }
    }
    return value;
  }
}
