package cronapp.reports.j4c;

import java.awt.*;
import java.io.Serializable;

import cronapp.reports.j4c.commons.J4CPosition;
import cronapp.reports.j4c.commons.J4CTextMode;

/**
 * Implementação de uma informação de texto no relatório como um título, campo ou valor.
 *
 * Created by arthemus on 07/06/16.
 */
public class J4CText implements Serializable, Cloneable {
  
  private String value;
  
  private J4CFont font;
  
  private J4CTextMode mode;
  
  private Color forecolor;
  
  private Color backcolor;
  
  private J4CPosition horizontalAlignment;
  
  private J4CPosition verticalAlignment;
  
  private J4CBorder borderTop;
  
  private J4CBorder borderBottom;
  
  private J4CBorder borderLeft;
  
  private J4CBorder borderRight;
  
  public J4CText() {
    this.value = "";
    this.font = new J4CFont();
    this.mode = J4CTextMode.OPAQUE;
    this.forecolor = Color.BLACK;
    this.backcolor = Color.WHITE;
    this.horizontalAlignment = J4CPosition.LEFT;
    this.verticalAlignment = J4CPosition.TOP;
    this.borderTop = new J4CBorder();
    this.borderBottom = new J4CBorder();
    this.borderLeft = new J4CBorder();
    this.borderRight = new J4CBorder();
  }
  
  public J4CText(String value) {
    this();
    this.value = value;
  }
  
  public String getValue() {
    return value;
  }
  
  public void setValue(String value) {
    this.value = value;
  }
  
  public J4CFont getFont() {
    return font;
  }
  
  public void setFont(J4CFont font) {
    this.font = font;
  }
  
  public J4CTextMode getMode() {
    return mode;
  }
  
  public void setMode(J4CTextMode mode) {
    this.mode = mode;
  }
  
  public Color getForecolor() {
    return forecolor;
  }
  
  public void setForecolor(Color forecolor) {
    this.forecolor = forecolor;
  }
  
  public Color getBackcolor() {
    return backcolor;
  }
  
  public void setBackcolor(Color backcolor) {
    this.backcolor = backcolor;
  }
  
  public J4CPosition getHorizontalAlignment() {
    return horizontalAlignment;
  }
  
  public void setHorizontalAlignment(J4CPosition horizontalAlignment) {
    this.horizontalAlignment = horizontalAlignment;
  }
  
  public J4CPosition getVerticalAlignment() {
    return verticalAlignment;
  }
  
  public void setVerticalAlignment(J4CPosition verticalAlignment) {
    this.verticalAlignment = verticalAlignment;
  }
  
  public J4CBorder getBorderTop() {
    return borderTop;
  }
  
  public void setBorderTop(J4CBorder borderTop) {
    this.borderTop = borderTop;
  }
  
  public J4CBorder getBorderBottom() {
    return borderBottom;
  }
  
  public void setBorderBottom(J4CBorder borderBottom) {
    this.borderBottom = borderBottom;
  }
  
  public J4CBorder getBorderLeft() {
    return borderLeft;
  }
  
  public void setBorderLeft(J4CBorder borderLeft) {
    this.borderLeft = borderLeft;
  }
  
  public J4CBorder getBorderRight() {
    return borderRight;
  }
  
  public void setBorderRight(J4CBorder borderRight) {
    this.borderRight = borderRight;
  }
  
  // TODO Essa verificação pode ser melhorada para uma opção em tela indicando que o valor do componente é um tipo de expressão.
  public boolean isExpressionValue() {
    return this.value.contains("$P{");
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CText j4CText = (J4CText)o;
    if(value != null ? !value.equals(j4CText.value) : j4CText.value != null)
      return false;
    if(font != null ? !font.equals(j4CText.font) : j4CText.font != null)
      return false;
    if(mode != j4CText.mode)
      return false;
    if(forecolor != null ? !forecolor.equals(j4CText.forecolor) : j4CText.forecolor != null)
      return false;
    if(backcolor != null ? !backcolor.equals(j4CText.backcolor) : j4CText.backcolor != null)
      return false;
    if(horizontalAlignment != j4CText.horizontalAlignment)
      return false;
    if(verticalAlignment != j4CText.verticalAlignment)
      return false;
    if(borderTop != null ? !borderTop.equals(j4CText.borderTop) : j4CText.borderTop != null)
      return false;
    if(borderBottom != null ? !borderBottom.equals(j4CText.borderBottom) : j4CText.borderBottom != null)
      return false;
    if(borderLeft != null ? !borderLeft.equals(j4CText.borderLeft) : j4CText.borderLeft != null)
      return false;
    return borderRight != null ? borderRight.equals(j4CText.borderRight) : j4CText.borderRight == null;
  }
  
  @Override
  public int hashCode() {
    int result = value != null ? value.hashCode() : 0;
    result = 31 * result + (font != null ? font.hashCode() : 0);
    result = 31 * result + (mode != null ? mode.hashCode() : 0);
    result = 31 * result + (forecolor != null ? forecolor.hashCode() : 0);
    result = 31 * result + (backcolor != null ? backcolor.hashCode() : 0);
    result = 31 * result + (horizontalAlignment != null ? horizontalAlignment.hashCode() : 0);
    result = 31 * result + (verticalAlignment != null ? verticalAlignment.hashCode() : 0);
    result = 31 * result + (borderTop != null ? borderTop.hashCode() : 0);
    result = 31 * result + (borderBottom != null ? borderBottom.hashCode() : 0);
    result = 31 * result + (borderLeft != null ? borderLeft.hashCode() : 0);
    result = 31 * result + (borderRight != null ? borderRight.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "J4CText{" + "value='" + value + '\'' + '}';
  }
  
  @Override
  public J4CText clone() {
    try {
      J4CText clone = (J4CText)super.clone();
      clone.setFont(this.font == null ? null : this.font.clone());
      clone.setBorderTop(this.borderTop == null ? null : this.borderTop.clone());
      clone.setBorderBottom(this.borderBottom == null ? null : this.borderBottom.clone());
      clone.setBorderLeft(this.borderLeft == null ? null : this.borderLeft.clone());
      clone.setBorderRight(this.borderRight == null ? null : this.borderRight.clone());
      return clone;
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  
}
