package cronapp.reports;

import java.io.InputStream;
import java.sql.Connection;
import java.util.Collection;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;

/**
 * @author arthemus
 * @since 17/08/17
 */
public class PrintCompile {
  
  private static final Logger log = LoggerFactory.getLogger(PrintCompile.class);
  
  private final InputStream inputStream;
  private final String fileTarget;
  
  private Map<String, Object> parameters;
  
  PrintCompile(InputStream inputStream, String fileTarget) {
    this.inputStream = inputStream;
    this.fileTarget = fileTarget;
  }
  
  public PrintCompile setParameters(Map<String, Object> parameters) {
    this.parameters = parameters;
    return this;
  }
  
  public ReportExport print(Connection connection) {
    JasperPrint jasperPrint;
    try {
      jasperPrint = JasperFillManager.fillReport(inputStream, parameters, connection);
    }
    catch(JRException e) {
      log.error("Problems during the compile.");
      throw new RuntimeException(e);
    }
    return new ReportExport(fileTarget, jasperPrint);
  }
  
  public ReportExport print(Collection<Object> objectCollection) {
    JasperPrint jasperPrint;
    try {
      JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(objectCollection);
      jasperPrint = JasperFillManager.fillReport(inputStream, parameters, dataSource);
    }
    catch(JRException e) {
      log.error("Problems during the compile.");
      throw new RuntimeException(e);
    }
    return new ReportExport(fileTarget, jasperPrint);
  }
  
}
