package cronapp.reports.j4c.export;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.util.Map;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import cronapp.reports.j4c.J4CObject;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;

/**
 * Exportação do conteudo xml do relatório.
 * 
 * Created by arthemus on 10/06/16.
 */
public class JrxmlExport implements J4CExport<String> {
  
  private final J4CObject j4CObject;
  private final Connection connection;
  
  JrxmlExport(J4CObject j4CObject, Connection connection) {
    this.j4CObject = j4CObject;
    this.connection = connection;
  }
  
  @Override
  public String get() {
    DynamicReportExport dynamicReportExport = j4CObject.build().toDynamicReport(connection);
    try {
      DynamicReport dynamicReport = dynamicReportExport.get();
      Map<String, Object> parameters = j4CObject.getParametersDefaultValue();
      
      String jrxml = DynamicJasperHelper.generateJRXML(dynamicReport, new ClassicLayoutManager(), parameters, "UTF-8");
      jrxml = jrxml.replaceAll("scriptletClass=\"ar.com.fdvs.dj.core.DJDefaultScriptlet\"", "");
      jrxml = jrxml.replace("<![CDATA[\"$P{", "<![CDATA[$P{").replace("}\"]]>", "}]]>");
      
      InputStream contentStream = new ByteArrayInputStream(jrxml.getBytes(StandardCharsets.UTF_8));
      JasperDesign jasperDesign = JRXmlLoader.load(contentStream);
      
      this.j4CObject.getParameters().forEach(parameter -> {
        
        JRDesignExpression designExpression = new JRDesignExpression();
        
        JRDesignParameter designParameter = new JRDesignParameter();
        designParameter.setName(parameter.getName());
        designParameter.setDefaultValueExpression(designExpression);
        if (parameter.getValue() != null && parameter.getName().startsWith("image_")) {
          String v = parameter.getValue().toString();
          if ("java.lang.String".equals(parameter.getType()) && !v.startsWith("\""))
            v = "\""+v+"\"";
          designExpression.setText(v);
        }

        JRParameter jrParameter = jasperDesign.getParametersMap().get(designParameter.getName());
        if(jrParameter == null) {
          try {
            jasperDesign.addParameter(designParameter);
          }
          catch(JRException e) {
            throw new RuntimeException(e);
          }
        }
        else {
          ((JRDesignParameter)jrParameter).setDefaultValueExpression(designExpression);
        }
      });
      
      return JasperCompileManager.writeReportToXml(jasperDesign);
    }
    catch(JRException e) {
      throw new RuntimeException(e);
    }
  }
}
