package cronapp.reports.j4c.dataset.jdbc;

import java.util.HashMap;
import java.util.Map;

public class Relation extends DatabaseObject {
  
  private final Map<String, Column> columns;
  
  public Relation(String tableName) {
    super(tableName);
    this.columns = new HashMap<>();
  }
  
  public Map<String, Column> getColumns() {
    return columns;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    Relation relation = (Relation)o;
    return columns.equals(relation.columns);
  }
  
  @Override
  public int hashCode() {
    return columns.hashCode();
  }
  
  @Override
  public String toString() {
    return "Relation{" + "columns=" + columns + '}';
  }
}
