package cronapp.reports.j4c;

import java.io.Serializable;

import cronapp.reports.j4c.commons.J4CGroupLayout;

/**
 * Implementação de um grupo para os dados do relatório.
 *
 * Created by arthemus on 01/07/16.
 */
public class J4CGroup implements Serializable, Cloneable {
  
  private String column;
  
  private J4CGroupLayout groupLayout;
  
  private J4CSummary summary;

  private boolean startInNewPage;
  
  public J4CGroup() {
    this.groupLayout = J4CGroupLayout.DEFAULT;
    this.startInNewPage = false;
  }
  
  public String getColumn() {
    return column;
  }
  
  public void setColumn(String column) {
    this.column = column;
  }
  
  public J4CGroupLayout getGroupLayout() {
    return groupLayout;
  }
  
  public void setGroupLayout(J4CGroupLayout groupLayout) {
    this.groupLayout = groupLayout;
  }
  
  public J4CSummary getSummary() {
    return summary;
  }
  
  public void setSummary(J4CSummary summary) {
    this.summary = summary;
  }

  public boolean isStartInNewPage() {
    return startInNewPage;
  }

  public void setStartInNewPage(boolean startInNewPage) {
    this.startInNewPage = startInNewPage;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    J4CGroup j4CGroup = (J4CGroup) o;
    if (startInNewPage != j4CGroup.startInNewPage) return false;
    if (column != null ? !column.equals(j4CGroup.column) : j4CGroup.column != null) return false;
    if (groupLayout != j4CGroup.groupLayout) return false;
    return summary != null ? summary.equals(j4CGroup.summary) : j4CGroup.summary == null;
  }

  @Override
  public int hashCode() {
    int result = column != null ? column.hashCode() : 0;
    result = 31 * result + (groupLayout != null ? groupLayout.hashCode() : 0);
    result = 31 * result + (summary != null ? summary.hashCode() : 0);
    result = 31 * result + (startInNewPage ? 1 : 0);
    return result;
  }

  @Override
  public String toString() {
    return "J4CGroup{" + "column='" + column + '\'' + '}';
  }
  
  @Override
  public J4CGroup clone() {
    try {
      J4CGroup clone = (J4CGroup)super.clone();
      clone.setSummary(this.summary == null ? null : this.summary.clone());
      return clone;
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  
}
