package cronapp.reports.j4c.export;

import com.google.gson.Gson;

import cronapp.reports.commons.GsonSingleton;
import cronapp.reports.j4c.J4CObject;

/**
 * Created by arthemus on 08/06/16.
 */
public class JsonExport implements J4CExport<String> {
  
  private final J4CObject j4CObject;
  private final Gson gson;
  
  JsonExport(J4CObject j4CObject) {
    this.j4CObject = j4CObject;
    this.gson = GsonSingleton.INSTANCE.get();
  }
  
  @Override
  public String get() {
    return this.gson.toJson(this.j4CObject);
  }
}
