package cronapp.reports.j4c.dataset;

import java.math.BigDecimal;
import java.util.Date;

import cronapp.reports.commons.Functions;
import cronapp.reports.commons.Geleia;
import io.zatarox.squiggle.Matchable;
import io.zatarox.squiggle.literal.BigDecimalLiteral;
import io.zatarox.squiggle.literal.BooleanLiteral;
import io.zatarox.squiggle.literal.DateTimeLiteral;
import io.zatarox.squiggle.literal.FloatLiteral;
import io.zatarox.squiggle.literal.IntegerLiteral;

/**
 * Utilitários para o módulo de build sql e dataset.
 * 
 * Created by Arthemus on 22/09/2016.
 */
public class CriteriaUtil {
  
  public static Matchable newBigDecimalValue(BigDecimal value) {
    return new BigDecimalLiteral(value);
  }
  
  public static Matchable newBooleanValue(boolean value) {
    return new BooleanLiteral(value);
  }
  
  public static Matchable newDateValue(Date value) {
    return new DateTimeLiteral(value);
  }
  
  public static Matchable newDoubleValue(double value) {
    return new FloatLiteral(value);
  }
  
  public static Matchable newLongValue(long value) {
    return new IntegerLiteral(value);
  }
  
  public static Matchable newStringValue(String value) {
    return new StringLiteralWithoutQuote(value);
  }
  
  public static Matchable newMatch(Object value) {
    if(value == null)
      return newStringValue("");
    String type = value.getClass().getSimpleName();
    switch(type) {
      case "Boolean":
        return newBooleanValue((Boolean)value);
      
      case "Short":
      case "Integer":
      case "Long":
        return newLongValue(Geleia.longNotNull(String.valueOf(value)));
      
      case "Float":
      case "Double":
        return newDoubleValue(Geleia.doubleNotNull(String.valueOf(value)));
      
      case "Date":
      case "Time":
      case "Timestamp":
        return newDateValue((Date)value);
      
      default:
        return newStringValue((String)value);
    }
  }
  
  public static Object fromType(String value, String type) {
    if(Functions.isExists(value) && value.startsWith("$")) {
      return value;
    }
    else {
      switch(type) {
        case "Boolean":
          return Geleia.booleanNotNull(value);
        
        case "Short":
          return Geleia.shortNotNull(value);
        
        case "Integer":
          return Geleia.intNotNull(value);
        
        case "Long":
          return Geleia.longNotNull(value);
        
        case "Float":
          return Geleia.floatNotNull(value);
        
        case "Double":
          return Geleia.doubleNotNull(value);
        
        default:
          return Geleia.stringNotNull(value);
      }
    }
  }
}
