package cronapp.reports.j4c.commons;

import java.util.stream.Stream;

/**
 * Operadores de comparação.
 *
 * Created by arthemus on 21/09/2016.
 */
public enum J4CMatchOperator {
  
  EQUALS("="),
  
  GREATER(">"),
  
  GREATER_EQUAL(">="),
  
  LESS("<"),
  
  LESS_EQUAL("<="),
  
  LIKE("LIKE"),
  
  NOT_EQUAL("<>");
  
  private final String operator;
  
  J4CMatchOperator(String operator) {
    this.operator = operator;
  }
  
  public String getOperator() {
    return operator;
  }
  
  public static String[] names() {
    return Stream.of(J4CMatchOperator.values()).map(J4CMatchOperator::name).toArray(String[]::new);
  }
  
  public static String[] operators() {
    return Stream.of(J4CMatchOperator.values())
            .map(J4CMatchOperator -> String.valueOf(J4CMatchOperator.getOperator()))
            .toArray(String[]::new);
  }
  
  public static J4CMatchOperator getByOperator(String operator) {
    for(J4CMatchOperator e : J4CMatchOperator.values())
      if(operator == e.operator)
        return e;
    return null;
  }
  
}
