package cronapp.reports.j4c;

import java.io.Serializable;

import cronapp.reports.j4c.commons.J4CUtils;

/**
 * Parâmetros internos do relatório.
 *
 * @author arthemus
 * @since 17/01/17
 */
public class J4CParameter implements Serializable, Cloneable {
  
  private String name;
  
  private String description;
  
  private String type;
  
  private Object value;
  
  public J4CParameter() {
    this.name = "";
    this.type = String.class.getName();
    this.value = "";
  }
  
  public J4CParameter(String name, String type) {
    this.name = name;
    this.type = type;
    this.value = J4CUtils.defaultValueBy(type);
  }
  
  public J4CParameter(String name, String type, Object value) {
    this.name = name;
    this.type = type;
    this.value = value;
  }
  
  public J4CParameter(String name, String description, String type, Object value) {
    this.name = name;
    this.type = type;
    this.value = value;
    this.description = description;
  }
  
  public String getName() {
    return name;
  }
  
  public void setName(String name) {
    this.name = name;
  }
  
  public String getType() {
    return type;
  }
  
  public void setType(String type) {
    this.type = type;
  }
  
  public Object getValue() {
    return J4CUtils.checkValue(type, value);
  }
  
  public void setValue(Object value) {
    this.value = value;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CParameter that = (J4CParameter)o;
    return name != null ? name.equals(that.name) : that.name == null;
  }
  
  @Override
  public int hashCode() {
    return name != null ? name.hashCode() : 0;
  }
  
  @Override
  public String toString() {
    return "J4CParameter{" + "name='" + name + '\'' + '}';
  }
  
  @Override
  public J4CParameter clone() {
    try {
      return (J4CParameter)super.clone();
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  
  /**
   * Transforma um determinado parametro da escrita original de relatório para a escrita utilizada nas consultas JPQL.
   *
   * Ex: $P{CODE} -> :CODE
   *
   * @param parameter
   *          Parametro a ser modificado.
   * @return Parametro na forma utilizada em consultas JPQL.
   */
  public static String formatJPQL(String parameter) {
    return parameter.replace("$P{", ":").replace("}", "");
  }
  
  /**
   * @return the description
   */
  public String getDescription() {
    if (description == null)
      description = "";
    return description;
  }
  
  /**
   * @param description
   *          the description to set
   */
  public void setDescription(String description) {
    this.description = description;
  }
  
}
