package cronapp.reports.j4c.dataset.jdbc;

public class Index extends DatabaseObject {
  
  private final boolean isUnique;
  private final ColumnsReference columns;
  
  public Index(String name, String tableName, String columnName, boolean isUnique) {
    this(name, new ColumnsReference(tableName, columnName), isUnique);
  }
  
  public Index(String name, ColumnsReference columns, boolean isUnique) {
    super(name);
    this.columns = columns;
    this.isUnique = isUnique;
  }
  
  public ColumnsReference getColumns() {
    return columns;
  }
  
  public boolean isUnique() {
    return isUnique;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    Index index = (Index)o;
    if(isUnique != index.isUnique)
      return false;
    return columns != null ? columns.equals(index.columns) : index.columns == null;
  }
  
  @Override
  public int hashCode() {
    int result = (isUnique ? 1 : 0);
    result = 31 * result + (columns != null ? columns.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "Index{" + "isUnique=" + isUnique + ", columns=" + columns + '}';
  }
}
