package cronapp.reports.j4c.commons;

import java.util.stream.Stream;

/**
 * Espessuras possíveis para a borda dos componentes.
 * <p>
 * Created by arthemus on 08/07/16.
 */
public enum J4CBorderWidth {

    NONE(0.0f),

    THIN(0.5f),

    POINT_1(1.0f),

    POINT_2(2.0f),

    POINT_4(4.0f);

    private final float width;

    J4CBorderWidth(float width) {
        this.width = width;
    }

    public float getWidth() {
        return width;
    }

    public static String[] names() {
        return Stream.of(J4CBorderWidth.values()).map(J4CBorderWidth::name).toArray(String[]::new);
    }

    public static String[] widths() {
        return Stream.of(J4CBorderWidth.values()).map(j4CBorderWidth -> String.valueOf(j4CBorderWidth.getWidth())).toArray(String[]::new);
    }

    public static J4CBorderWidth getByWidth(float width) {
        for (J4CBorderWidth e : J4CBorderWidth.values())
            if (width == e.width)
                return e;
        return null;
    }

}
