package cronapp.reports.j4c;

import java.io.Serializable;

import cronapp.reports.j4c.commons.J4CCalculation;

/**
 * Classe de representação de um sub-total do relatório.
 * 
 * Created by arthemus on 05/05/16.
 */
public class J4CSummary implements Serializable, Cloneable {
  
  private String column;
  
  private J4CCalculation calculation;
  
  private J4CText label;
  
  private J4CText value;
  
  public J4CSummary() {
    this.calculation = J4CCalculation.COUNT;
    this.label = new J4CText();
    this.value = new J4CText();
  }
  
  public String getColumn() {
    return column;
  }
  
  public void setColumn(String column) {
    this.column = column;
  }
  
  public J4CCalculation getCalculation() {
    return calculation;
  }
  
  public void setCalculation(J4CCalculation calculation) {
    this.calculation = calculation;
  }
  
  public J4CText getLabel() {
    return label;
  }
  
  public void setLabel(J4CText label) {
    this.label = label;
  }
  
  public J4CText getValue() {
    return value;
  }
  
  public void setValue(J4CText value) {
    this.value = value;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CSummary that = (J4CSummary)o;
    if(column != null ? !column.equals(that.column) : that.column != null)
      return false;
    if(calculation != that.calculation)
      return false;
    if(label != null ? !label.equals(that.label) : that.label != null)
      return false;
    return value != null ? value.equals(that.value) : that.value == null;
  }
  
  @Override
  public int hashCode() {
    int result = column != null ? column.hashCode() : 0;
    result = 31 * result + (calculation != null ? calculation.hashCode() : 0);
    result = 31 * result + (label != null ? label.hashCode() : 0);
    result = 31 * result + (value != null ? value.hashCode() : 0);
    return result;
  }
  
  @Override
  public String toString() {
    return "J4CSummary{" + "column='" + column + '\'' + ", calculation=" + calculation + ", label=" + label +
            ", value=" + value + '}';
  }
  
  @Override
  public J4CSummary clone() {
    try {
      J4CSummary clone = (J4CSummary)super.clone();
      clone.setLabel(this.label == null ? null : this.label.clone());
      clone.setValue(this.value == null ? null : this.value.clone());
      return clone;
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  
}
