/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c.dataset.jdbc;

import cronapp.reports.j4c.dataset.jdbc.Column;
import cronapp.reports.j4c.dataset.jdbc.ColumnsReference;
import cronapp.reports.j4c.dataset.jdbc.ForeignKey;
import cronapp.reports.j4c.dataset.jdbc.Index;
import cronapp.reports.j4c.dataset.jdbc.PrimaryKey;
import cronapp.reports.j4c.dataset.jdbc.Relation;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class JDBC {
    public static Map<String, ForeignKey> fetchForeignKeys(Connection conn, String table) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        return JDBC.fetchForeignKeys(meta, catalog, table);
    }

    static Map<String, ForeignKey> fetchForeignKeys(DatabaseMetaData meta, String catalog, String table) throws SQLException {
        HashMap<String, ForeignKey> result = new HashMap<String, ForeignKey>();
        try (ResultSet rs = meta.getImportedKeys(catalog, null, table);){
            HashMap<String, ForeignKey> fkNameMap = new HashMap<String, ForeignKey>();
            while (rs.next()) {
                String fkName = rs.getString("FK_NAME");
                String fkTableName = rs.getString("FKTABLE_NAME");
                String fkColumnName = rs.getString("FKCOLUMN_NAME");
                String pkTableName = rs.getString("PKTABLE_NAME");
                String pkColumnName = rs.getString("PKCOLUMN_NAME");
                ForeignKey current = (ForeignKey)fkNameMap.get(fkName);
                if (current != null) continue;
                current = new ForeignKey(fkName, new ColumnsReference(fkTableName, fkColumnName), new ColumnsReference(pkTableName, pkColumnName));
                fkNameMap.put(fkName, current);
            }
            for (ForeignKey fk : fkNameMap.values()) {
                result.put(fk.getSource().getTableName(), fk);
            }
        }
        return result;
    }

    public static Map<String, PrimaryKey> fetchPrimaryKeys(Connection conn, String table) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        return JDBC.fetchPrimaryKeys(meta, catalog, table);
    }

    static Map<String, PrimaryKey> fetchPrimaryKeys(DatabaseMetaData meta, String catalog, String table) throws SQLException {
        HashMap<String, PrimaryKey> result = new HashMap<String, PrimaryKey>();
        try (ResultSet rs = meta.getPrimaryKeys(catalog, null, table);){
            PrimaryKey current = null;
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                String pkName = rs.getString("PK_NAME");
                if (current != null && tableName.equals(current.getSource().getTableName())) continue;
                current = new PrimaryKey(pkName, new ColumnsReference(tableName, columnName));
                result.put(tableName, current);
            }
        }
        return result;
    }

    public static Set<String> fetchRelationNames(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        return JDBC.fetchRelationNames(meta, catalog);
    }

    private static Set<String> fetchRelationNames(DatabaseMetaData meta, String catalog) throws SQLException {
        TreeSet<String> result = new TreeSet<String>();
        String[] types = new String[]{"TABLE", "VIEW"};
        try (ResultSet rs = meta.getTables(catalog, null, null, types);){
            while (rs.next()) {
                result.add(rs.getString("TABLE_NAME"));
            }
        }
        return result;
    }

    public static Map<String, Relation> fetchColumns(Connection conn) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        return JDBC.fetchColumns(meta, catalog, null, null);
    }

    public static Map<String, Relation> fetchColumns(Connection conn, String schema) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        return JDBC.fetchColumns(meta, catalog, schema, null);
    }

    public static Map<String, Relation> fetchColumns(Connection conn, String schema, String table) throws SQLException {
        DatabaseMetaData meta = conn.getMetaData();
        String catalog = conn.getCatalog();
        return JDBC.fetchColumns(meta, catalog, schema, table);
    }

    static Map<String, Relation> fetchColumns(DatabaseMetaData meta, String catalog, String table) throws SQLException {
        return JDBC.fetchColumns(meta, catalog, null, table);
    }

    private static Map<String, Relation> fetchColumns(DatabaseMetaData meta, String catalog, String schema, String table) throws SQLException {
        HashMap<String, Relation> result = new HashMap<String, Relation>();
        try (ResultSet rs = meta.getColumns(catalog, schema, table, null);){
            Relation current = null;
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String columnName = rs.getString("COLUMN_NAME");
                int dataType = rs.getInt("DATA_TYPE");
                String rawIsNullable = rs.getString("IS_NULLABLE");
                int ordinalPosition = rs.getInt("ORDINAL_POSITION");
                Boolean isNullable = null;
                if ("YES".equalsIgnoreCase(rawIsNullable)) {
                    isNullable = true;
                } else if ("NO".equalsIgnoreCase(rawIsNullable)) {
                    isNullable = false;
                }
                if (current == null || !tableName.equals(current.getName())) {
                    current = new Relation(tableName);
                    result.put(tableName, current);
                }
                Column column = new Column(ordinalPosition, columnName, JDBCType.valueOf(dataType).getName(), isNullable);
                current.getColumns().put(columnName, column);
            }
        }
        return result;
    }

    public static Map<String, Index> fetchIndexes(DatabaseMetaData meta, String catalog, String schemaName, String tableName, boolean unique) throws SQLException {
        HashMap<String, Index> result = new HashMap<String, Index>();
        ResultSet rs = meta.getIndexInfo(catalog, schemaName, tableName, unique, false);
        Index current = null;
        while (rs.next()) {
            String indexName = rs.getString("INDEX_NAME");
            String table = rs.getString("TABLE_NAME");
            String columnName = rs.getString("COLUMN_NAME");
            boolean isNonUnique = rs.getBoolean("NON_UNIQUE");
            if (indexName == null || current != null && indexName.equals(current.getName())) continue;
            current = new Index(tableName, table, columnName, !isNonUnique);
            result.put(tableName, current);
        }
        return result;
    }

    public static String getSqlTypeName(int sqlType) {
        try {
            Integer val = sqlType;
            for (Field field : Types.class.getFields()) {
                if (!val.equals(field.get(null))) continue;
                return field.getName();
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get sqlTypeName ", e);
        }
        throw new RuntimeException("Unknown sqlType " + sqlType);
    }

    public static Class<?> getJavaType(int sqlType) {
        switch (sqlType) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class;
            }
            case -7: {
                return Boolean.class;
            }
            case -6: 
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case 2: {
                return Long.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 3: 
            case 8: {
                return Double.class;
            }
            case 6: {
                return Float.class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
        }
        return Object.class;
    }

    public static String getJavaType(String type) {
        return JDBC.getJavaType(JDBCType.valueOf(type).getVendorTypeNumber()).getSimpleName();
    }
}

