/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c.dataset;

import cronapp.reports.j4c.commons.J4CMatchOperator;
import cronapp.reports.j4c.dataset.CriteriaUtil;
import cronapp.reports.j4c.dataset.J4CColumn;
import cronapp.reports.j4c.dataset.J4CDataset;
import cronapp.reports.j4c.dataset.J4CTable;
import io.zatarox.squiggle.Column;
import io.zatarox.squiggle.Criteria;
import io.zatarox.squiggle.Matchable;
import io.zatarox.squiggle.Table;
import io.zatarox.squiggle.criteria.BetweenCriteria;
import io.zatarox.squiggle.criteria.MatchCriteria;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.swt.widgets.Control;

public class J4CWhereCondition
implements Serializable {
    private final transient LinkedHashMap<Control, Object> betweenComponents = new LinkedHashMap();
    private transient J4CDataset parent;
    private J4CColumn column;
    private String operator;
    private Set<Object> values;
    private String aspasQuery = "\"";

    private J4CWhereCondition() {
    }

    public J4CWhereCondition(J4CDataset parent, J4CColumn column, String operator, Object ... values) {
        this();
        this.parent = parent;
        this.column = column;
        this.operator = operator;
        this.values = new LinkedHashSet<Object>();
        this.values.addAll(Arrays.asList(ArrayUtils.nullToEmpty((Object[])values)));
    }

    public J4CWhereCondition(J4CDataset parent, J4CColumn column, J4CMatchOperator operator, Object ... values) {
        this();
        this.parent = parent;
        this.column = column;
        this.operator = operator.getOperator();
        this.values = new LinkedHashSet<Object>();
        this.values.addAll(Arrays.asList(ArrayUtils.nullToEmpty((Object[])values)));
    }

    public J4CDataset getParent() {
        return this.parent;
    }

    public J4CColumn getColumn() {
        return this.column;
    }

    public void setColumn(J4CColumn column) {
        this.column = column;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Collection<Object> getValues() {
        if (this.isBetween()) {
            return this.betweenComponents.values();
        }
        return this.values;
    }

    public Object[] getValuesArray() {
        if (this.isBetween()) {
            return this.betweenComponents.values().toArray();
        }
        return ArrayUtils.nullToEmpty((Object[])this.values.toArray());
    }

    private Object getUniqueValue() {
        Object[] array = this.getValuesArray();
        if (array != null && array.length > 0) {
            return array[0];
        }
        return null;
    }

    public void addValues(Object ... values) {
        if (this.isCommonComparation()) {
            this.values.clear();
            this.values.addAll(Arrays.asList(ArrayUtils.nullToEmpty((Object[])values)));
        }
    }

    public boolean isBetween() {
        return "BETWEEN".equals(this.operator);
    }

    public String getAspasQuery() {
        return this.aspasQuery;
    }

    public void setAspasQuery(String aspasQuery) {
        this.aspasQuery = aspasQuery;
    }

    public boolean isCommonComparation() {
        return Arrays.asList("=", "<>", ">", ">=", "<", "<=", "LIKE").contains(this.operator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        J4CWhereCondition that = (J4CWhereCondition)o;
        return this.column != null ? this.column.equals(that.column) : that.column == null && (this.operator != null ? this.operator.equals(that.operator) : that.operator == null && (this.values != null ? this.values.equals(that.values) : that.values == null && (this.betweenComponents != null ? this.betweenComponents.equals(that.betweenComponents) : that.betweenComponents == null)));
    }

    public int hashCode() {
        int result = this.column != null ? this.column.hashCode() : 0;
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        result = 31 * result + (this.betweenComponents != null ? this.betweenComponents.hashCode() : 0);
        return result;
    }

    public String toString() {
        String whereText = "";
        String columnName = this.aspasQuery + this.column.getParent().getName() + this.aspasQuery + "." + this.column.getName();
        if (this.isCommonComparation()) {
            whereText = columnName + " [" + this.operator + "]";
            Object[] values = this.getValuesArray();
            if (values.length > 0) {
                whereText = whereText + " [" + values[0] + "]";
            }
        } else if (this.isBetween()) {
            whereText = columnName + " [" + this.operator + "]";
            Object[] values = this.betweenComponents.values().toArray();
            if (values.length > 1) {
                whereText = whereText + " [" + values[0] + "]";
                whereText = whereText + " AND [" + values[1] + "]";
            }
        }
        return whereText;
    }

    public void addBetweenComponent(Control component) {
        this.betweenComponents.put(component, null);
    }

    public void addBetweenValue(Control component, Object value) {
        this.betweenComponents.put(component, value);
    }

    Criteria newCriteria() {
        J4CTable parent = this.column.getParent();
        Table table = new Table(this.aspasQuery + parent.getName() + this.aspasQuery, parent.getAs());
        Column column = table.getColumn(this.column.getName());
        if (this.isBetween()) {
            Object[] objects = this.betweenComponents.values().toArray();
            return new BetweenCriteria((Matchable)column, CriteriaUtil.newMatch(objects[0]), CriteriaUtil.newMatch(objects[1]));
        }
        return new MatchCriteria((Matchable)column, this.operator, CriteriaUtil.newMatch(this.getUniqueValue()));
    }
}

