/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports;

import cronapp.reports.PrintCompile;
import cronapp.reports.PrintDesign;
import cronapp.reports.commons.Parameter;
import java.io.InputStream;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportManager {
    private static final Logger log = LoggerFactory.getLogger(ReportManager.class);
    private final InputStream inputStream;
    private final String fileTarget;

    private ReportManager(InputStream inputStream, String fileTarget) {
        this.inputStream = inputStream;
        this.fileTarget = fileTarget;
    }

    public static ReportManager newPrint(InputStream inputStream, String fileTarget) {
        return new ReportManager(inputStream, fileTarget);
    }

    public PrintDesign byDesign(List<Parameter> frontParameters) {
        JasperDesign jasperDesign;
        try {
            jasperDesign = JRXmlLoader.load((InputStream)this.inputStream);
        }
        catch (JRException e) {
            log.error("Problems to make the design file from report.");
            throw new RuntimeException(e);
        }
        return new PrintDesign(jasperDesign, this.fileTarget, frontParameters);
    }

    public PrintCompile byCompile() {
        return new PrintCompile(this.inputStream, this.fileTarget);
    }
}

