/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c.dataset;

import cronapp.reports.commons.AutoObserver;
import cronapp.reports.commons.Functions;
import cronapp.reports.commons.Geleia;
import cronapp.reports.j4c.J4CObject;
import cronapp.reports.j4c.J4CParameter;
import cronapp.reports.j4c.commons.J4CDatasetType;
import cronapp.reports.j4c.commons.J4CUtils;
import cronapp.reports.j4c.dataset.J4CColumn;
import cronapp.reports.j4c.dataset.J4CEntity;
import cronapp.reports.j4c.dataset.J4CJoin;
import cronapp.reports.j4c.dataset.J4CSQLBuilder;
import cronapp.reports.j4c.dataset.J4CTable;
import cronapp.reports.j4c.dataset.J4CWhereCondition;
import cronapp.reports.j4c.dataset.jdbc.JDBC;
import io.zatarox.squiggle.SelectQuery;
import io.zatarox.squiggle.Table;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class J4CDataset
implements Serializable,
Cloneable {
    private transient J4CObject parent;
    private transient Collection<?> collection;
    private J4CDatasetType datasetType = J4CDatasetType.DATASOURCE;
    private boolean freeQuery = false;
    private String jndiConnection;
    private String sql;
    private J4CEntity entity;
    private int recordLimit;
    private List<J4CTable> tables;
    private List<J4CJoin> joins;
    private List<J4CColumn> columns;
    private List<J4CWhereCondition> wheres;
    private String persistenceUnitName;

    public J4CDataset() {
        this(new J4CObject());
    }

    public J4CDataset(J4CObject parent) {
        this.parent = parent;
    }

    public J4CObject getParent() {
        return this.parent;
    }

    public void synchronizeParent(J4CObject object) {
        this.parent = object;
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    public J4CDatasetType getDatasetType() {
        return this.datasetType;
    }

    public void setDatasetType(J4CDatasetType datasetType) {
        this.datasetType = datasetType;
    }

    public boolean isFreeQuery() {
        return this.freeQuery;
    }

    public void setFreeQuery(boolean freeQuery) {
        this.freeQuery = freeQuery;
    }

    public String getJndiConnection() {
        return this.jndiConnection;
    }

    public void setJndiConnection(String jndiConnection) {
        this.jndiConnection = jndiConnection;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public int getRecordLimit() {
        return this.recordLimit;
    }

    public void setRecordLimit(int recordLimit) {
        this.recordLimit = recordLimit;
    }

    public List<J4CTable> getTables() {
        if (this.tables == null) {
            this.tables = new LinkedList<J4CTable>();
        }
        return this.tables;
    }

    public J4CDataset addTable(J4CTable table) {
        this.getTables().add(table);
        table.getColumns().forEach(this::addColumn);
        return this;
    }

    public void removeTable(J4CTable table) {
        Iterator<J4CTable> iterator = this.getTables().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getName().equals(table.getName())) continue;
            iterator.remove();
        }
        table.getColumns().forEach(this::removeColumn);
    }

    private void removeAllTables() {
        this.tables = null;
    }

    public List<J4CJoin> getJoins() {
        if (this.joins == null) {
            this.joins = new LinkedList<J4CJoin>();
        }
        return this.joins;
    }

    public void addJoin(J4CJoin join) {
        this.getJoins().add(join);
        join.getLeft().getParent().getColumns().forEach(this::addColumn);
    }

    public void removeJoin(J4CJoin join) {
        Iterator<J4CJoin> iterator = this.getJoins().iterator();
        while (iterator.hasNext()) {
            J4CJoin next = iterator.next();
            if (!next.getLeft().equals(join.getLeft()) || !next.getRight().equals(join.getRight())) continue;
            next.getLeft().getParent().getColumns().forEach(this::removeColumn);
            iterator.remove();
        }
    }

    private void removeAllJoins() {
        this.joins = null;
    }

    public List<J4CColumn> getColumns() {
        if (this.columns == null) {
            this.columns = new LinkedList<J4CColumn>();
        }
        return this.columns;
    }

    public J4CDataset addColumn(J4CColumn column) {
        this.getColumns().add(column);
        return this;
    }

    public J4CDataset removeColumn(J4CColumn column) {
        Iterator<J4CColumn> iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getName().equals(column.getName())) continue;
            iterator.remove();
        }
        return this;
    }

    private void removeAllColumns() {
        this.columns = null;
    }

    public void addWhere(J4CWhereCondition whereCondition) {
        this.getWheres().add(whereCondition);
    }

    public void removeWhere(J4CWhereCondition j4CWhereCondition) {
        this.getWheres().removeIf(condition -> condition.equals(j4CWhereCondition));
    }

    private void removeAllWheres() {
        this.wheres = null;
    }

    public List<J4CWhereCondition> getWheres() {
        if (this.wheres == null) {
            this.wheres = new LinkedList<J4CWhereCondition>();
        }
        return this.wheres;
    }

    public void byCollection(Collection<?> collection) {
        this.datasetType = J4CDatasetType.COLLECTION;
        this.collection = collection;
    }

    public J4CSQLBuilder build(Connection connection) throws SQLException {
        return new J4CSQLBuilder(connection);
    }

    public J4CSQLBuilder build(Connection connection, AutoObserver<String> autoObserver) throws SQLException {
        return new J4CSQLBuilder(connection, autoObserver);
    }

    private SelectQuery buildSQL(String aspasQuery) {
        SelectQuery selectQuery = new SelectQuery();
        this.getColumns().forEach(j4CColumn -> {
            J4CTable j4CTable = j4CColumn.getParent();
            Table table = new Table(aspasQuery + j4CTable.getName() + aspasQuery, j4CTable.getAs());
            selectQuery.addColumn(table, j4CColumn.getName());
        });
        this.getJoins().forEach(join -> {
            J4CColumn left = join.getLeft();
            J4CTable leftParent = left.getParent();
            Table leftTable = new Table(aspasQuery + leftParent.getName() + aspasQuery, leftParent.getAs());
            J4CColumn right = join.getRight();
            J4CTable rightParent = right.getParent();
            Table rightTable = new Table(aspasQuery + rightParent.getName() + aspasQuery, rightParent.getAs());
            selectQuery.addJoin(leftTable, left.getName(), join.getOperator().getOperator(), rightTable, right.getName());
        });
        this.getWheres().forEach(where -> selectQuery.addCriteria(where.newCriteria()));
        return selectQuery;
    }

    public String getSql(Connection connection) {
        String aspasQuery = "";
        if (connection != null) {
            try {
                aspasQuery = "MySQL".equals(connection.getMetaData().getDatabaseProductName()) ? "`" : "\"";
            }
            catch (SQLException e1) {
                throw new RuntimeException(e1);
            }
        }
        switch (this.datasetType) {
            case DATASOURCE: {
                if (this.isFreeQuery()) {
                    return Geleia.stringNotNull(this.sql);
                }
                try {
                    String sql = this.buildSQL(aspasQuery).toString();
                    if (sql != null && sql.length() > 0 && !"SELECT".equals(sql)) {
                        return J4CUtils.getPrepareSQLQuery(connection, sql);
                    }
                    break;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return Geleia.stringNotNull(this.sql);
    }

    public J4CEntity getEntity() {
        if (this.entity == null) {
            this.entity = new J4CEntity();
        }
        return this.entity;
    }

    public void setEntity(J4CEntity entity) {
        this.entity = entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<J4CColumn, Object>> getDataPreview(Connection connection) throws SQLException {
        LinkedList<Map<J4CColumn, Object>> list = new LinkedList<Map<J4CColumn, Object>>();
        String sql = this.getSql(connection);
        if (Functions.isExists(sql)) {
            Statement preparedStatement = null;
            try {
                String[] columnNames = this.columns.stream().map(J4CColumn::getName).collect(Collectors.toList()).toArray(new String[0]);
                preparedStatement = connection.prepareStatement(sql, columnNames);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet != null) {
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    while (resultSet.next()) {
                        LinkedHashMap<J4CColumn, Object> record = new LinkedHashMap<J4CColumn, Object>();
                        int columnCount = metaData.getColumnCount();
                        for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                            J4CTable table = new J4CTable(metaData.getTableName(columnIndex));
                            String columnName = metaData.getColumnName(columnIndex);
                            String columnLabel = metaData.getColumnLabel(columnIndex);
                            int columnType = metaData.getColumnType(columnIndex);
                            J4CColumn column = new J4CColumn(table, columnName, columnLabel, JDBC.getJavaType(columnType).getSimpleName());
                            Object value = resultSet.getObject(columnIndex);
                            record.put(column, value);
                        }
                        list.add(record);
                    }
                }
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return list;
    }

    public SQLObject getSQLObject(Connection connection) {
        return new SQLObject(this.getSql(connection), this.getParent(), this.recordLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<J4CColumn> getDataPreviewWithoutRecords(Connection connection) throws SQLException {
        LinkedList<J4CColumn> list = new LinkedList<J4CColumn>();
        String sql = this.getSql(connection);
        if (Functions.isExists(sql)) {
            Statement preparedStatement = null;
            try {
                ResultSet resultSet;
                SQLObject sqlObject = this.getSQLObject(connection);
                String[] columnNames = this.getColumns().stream().map(J4CColumn::getName).collect(Collectors.toList()).toArray(new String[0]);
                preparedStatement = connection.prepareStatement(sqlObject.getSQLAnsi(), columnNames);
                if (sqlObject.hasParameters()) {
                    Iterator<Map.Entry<String, Object>> iterator = sqlObject.getParameters().entrySet().iterator();
                    int count = 0;
                    while (iterator.hasNext()) {
                        Map.Entry<String, Object> entry = iterator.next();
                        preparedStatement.setObject(++count, entry.getValue());
                    }
                }
                if ((resultSet = preparedStatement.executeQuery()) != null) {
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    int columnCount = metaData.getColumnCount();
                    for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                        String columnName = metaData.getColumnName(columnIndex);
                        String columnLabel = metaData.getColumnLabel(columnIndex);
                        int columnType = metaData.getColumnType(columnIndex);
                        list.add(new J4CColumn(columnName, columnLabel, JDBC.getJavaType(columnType).getName()));
                    }
                }
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return list;
    }

    public List<J4CColumn> getDataPreviewWithoutRecords(URLClassLoader classLoader) throws Exception {
        String entity;
        LinkedList<J4CColumn> list = new LinkedList<J4CColumn>();
        if (this.entity != null && Functions.isExists(entity = this.entity.getEntity())) {
            Field[] fields;
            Class<?> classReference = classLoader.loadClass(entity);
            for (Field field : fields = classReference.getDeclaredFields()) {
                String fieldName = field.getName();
                if (fieldName.equalsIgnoreCase("serialVersionUID")) continue;
                list.add(new J4CColumn(fieldName, fieldName, field.getType().getName()));
            }
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        J4CDataset that = (J4CDataset)o;
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        if (this.jndiConnection != null ? !this.jndiConnection.equals(that.jndiConnection) : that.jndiConnection != null) {
            return false;
        }
        if (this.sql != null ? !this.sql.equals(that.sql) : that.sql != null) {
            return false;
        }
        if (this.tables != null ? !this.tables.equals(that.tables) : that.tables != null) {
            return false;
        }
        if (this.joins != null ? !this.joins.equals(that.joins) : that.joins != null) {
            return false;
        }
        if (this.columns != null ? !this.columns.equals(that.columns) : that.columns != null) {
            return false;
        }
        return this.wheres != null ? this.wheres.equals(that.wheres) : that.wheres == null;
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + (this.jndiConnection != null ? this.jndiConnection.hashCode() : 0);
        result = 31 * result + (this.sql != null ? this.sql.hashCode() : 0);
        result = 31 * result + (this.tables != null ? this.tables.hashCode() : 0);
        result = 31 * result + (this.joins != null ? this.joins.hashCode() : 0);
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        result = 31 * result + (this.wheres != null ? this.wheres.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "J4CDataset{jndiConnection='" + this.jndiConnection + '\'' + '}';
    }

    public J4CDataset clone() {
        try {
            J4CDataset clone = (J4CDataset)super.clone();
            clone.parent = this.getParent().clone();
            clone.tables = new ArrayList<J4CTable>(this.getTables());
            clone.columns = new ArrayList<J4CColumn>(this.getColumns());
            clone.joins = new ArrayList<J4CJoin>(this.getJoins());
            clone.wheres = new ArrayList<J4CWhereCondition>(this.getWheres());
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasParentTables() {
        return this.getTables().size() > 0;
    }

    public List<J4CTable> getParentTables() {
        HashSet parentTables = new HashSet();
        ArrayList<J4CTable> tables = new ArrayList<J4CTable>(this.getTables());
        tables.forEach(parentTables::add);
        List<J4CTable> joins = this.getJoins().stream().map(join -> join.getLeft().getParent()).collect(Collectors.toList());
        joins.forEach(parentTables::add);
        return new ArrayList<J4CTable>(parentTables);
    }

    public boolean hasColumn(J4CColumn column) {
        return this.hasColumn(this.getColumns(), column);
    }

    public boolean hasColumn(Collection<J4CColumn> columnsSource, J4CColumn column) {
        return columnsSource.stream().anyMatch(j4CColumn -> j4CColumn.getName().equals(column.getName()));
    }

    public void onRefreshTransientObjects(Connection connection) {
        LinkedList tablesUpdated = new LinkedList();
        try {
            J4CSQLBuilder builder = this.build(connection);
            List<J4CTable> tablesFromDB = builder.listTables();
            this.getTables().forEach(table -> {
                Optional<J4CTable> optional = tablesFromDB.stream().filter(j4CTable -> j4CTable.getName().equals(table.getName())).findFirst();
                if (optional.isPresent()) {
                    J4CTable j4CTable2 = optional.get();
                    try {
                        builder.populateTable(j4CTable2);
                        tablesUpdated.add(j4CTable2.clone());
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Erro ao tentar ler as colunas do banco de dados.", e);
                    }
                } else {
                    throw new RuntimeException(String.format("Table %s not found.", table.getName()));
                }
            });
            LinkedList<J4CColumn> columnsBackup = new LinkedList<J4CColumn>();
            columnsBackup.addAll(this.getColumns());
            LinkedList<J4CJoin> joinsBackup = new LinkedList<J4CJoin>();
            joinsBackup.addAll(this.getJoins());
            this.removeAllTables();
            this.removeAllColumns();
            this.removeAllJoins();
            tablesUpdated.forEach(this::addTable);
            joinsBackup.forEach(join -> {
                J4CJoin newJoin = join.clone();
                J4CTable parentLeft = join.getLeft().getParent();
                Optional<J4CTable> optionalLeft = tablesFromDB.stream().filter(j4CTable -> j4CTable.getName().equals(parentLeft.getName())).findFirst();
                if (optionalLeft.isPresent()) {
                    J4CTable table = optionalLeft.get();
                    try {
                        builder.populateTable(table);
                        J4CColumn clone = join.getLeft().clone();
                        clone.setParent(table);
                        newJoin.setLeft(clone);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Erro ao tentar ler as colunas do banco de dados.", e);
                    }
                }
                J4CTable parentRight = join.getRight().getParent();
                Optional<J4CTable> optionalRight = tablesFromDB.stream().filter(j4CTable -> j4CTable.getName().equals(parentRight.getName())).findFirst();
                if (optionalRight.isPresent()) {
                    J4CTable table = optionalRight.get();
                    try {
                        builder.populateTable(table);
                        J4CColumn clone = join.getRight().clone();
                        clone.setParent(table);
                        newJoin.setRight(clone);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Erro ao tentar ler as colunas do banco de dados.", e);
                    }
                }
                this.addJoin(newJoin);
            });
            Iterator<J4CColumn> iterator = this.getColumns().iterator();
            while (iterator.hasNext()) {
                J4CColumn column = iterator.next();
                Optional<J4CColumn> optional = columnsBackup.stream().filter(j4CColumn -> j4CColumn.getName().equals(column.getName())).findFirst();
                if (optional.isPresent()) continue;
                iterator.remove();
            }
            this.getColumns().sort(Comparator.comparing(columnsBackup::indexOf));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        this.removeAllTables();
        this.removeAllColumns();
        this.removeAllJoins();
        this.removeAllWheres();
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public void replaceColumns(List<J4CColumn> columns) {
        this.columns.clear();
        this.columns.addAll(columns);
    }

    public class SQLObject {
        private final String sql;
        private final LinkedHashMap<String, Object> parameters = new LinkedHashMap();

        SQLObject(String sql, J4CObject object, int dataLimit) {
            String delims = " \n\r\t.(),+";
            String quots = "'";
            StringBuilder token = new StringBuilder();
            boolean isQuoted = false;
            LinkedList<String> tokens = new LinkedList<String>();
            for (int i = 0; i < sql.length(); ++i) {
                if (quots.indexOf(sql.charAt(i)) != -1) {
                    boolean bl = isQuoted = token.length() == 0;
                }
                if (delims.indexOf(sql.charAt(i)) == -1 || isQuoted) {
                    token.append(sql.charAt(i));
                    continue;
                }
                if (token.length() <= 0) continue;
                tokens.add(token.toString());
                token = new StringBuilder();
                isQuoted = false;
            }
            if (token.length() > 0) {
                tokens.add(token.toString());
            }
            List<String> parameters = tokens.stream().filter(s -> s.startsWith("$P{")).collect(Collectors.toList());
            String[] newSQL = new String[]{sql};
            parameters.forEach(p -> {
                String parameterClean = p.replace("$P{", "").replace("}", "");
                J4CParameter parameter = object.hasParameter(parameterClean);
                if (parameter != null) {
                    this.parameters.put(parameter.getName(), J4CUtils.defaultValueBy(parameter.getType()));
                    newSQL[0] = newSQL[0].replace((CharSequence)p, "?");
                }
            });
            this.sql = newSQL[0];
        }

        String getSQLAnsi() {
            return this.sql;
        }

        public boolean hasParameters() {
            return !this.parameters.isEmpty();
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }
    }
}

