package cronapp.reports.j4c.dataset;

import cronapp.reports.commons.Functions;
import io.zatarox.squiggle.literal.StringLiteral;

/**
 * Implementação do {@link io.zatarox.squiggle.literal.StringLiteral} sem aspas caso o valor passado tenha o padrão de
 * um parâmetro do JasperReports.
 * 
 * Created by Arthemus on 23/09/2016.
 */
class StringLiteralWithoutQuote extends StringLiteral {
  
  StringLiteralWithoutQuote(String literalValue) {
    super(literalValue);
  }
  
  @Override
  protected String quote(String s) {
    if(Functions.isExists(s))
      if(s.startsWith("$"))
        return s.trim();
    return super.quote(s);
  }
  
}
