package cronapp.reports.j4c.dataset;

import cronapp.reports.commons.Geleia;

import java.io.Serializable;



/**
 * Quando o dataset de relatórios utilizar Entities JPA para geração dos dados.
 *
 * @author arthemus
 * @since 13/07/17
 */
public class J4CEntity implements Serializable, Cloneable {
  
  private String entity;
  
  private String jpql;
  
  public J4CEntity() {
  }
  
  public J4CEntity(String entity, String jpql) {
    this.entity = entity;
    this.jpql = jpql;
  }
  
  public String getEntity() {
    return entity;
  }
  
  public void setEntity(String entity) {
    this.entity = entity;
  }
  
  public String getJpql() {
    return Geleia.stringNotNull(jpql);
  }
  
  public void setJpql(String jpql) {
    this.jpql = jpql;
  }
  
  @Override
  public boolean equals(Object o) {
    if(this == o)
      return true;
    if(o == null || getClass() != o.getClass())
      return false;
    J4CEntity j4CEntity = (J4CEntity)o;
    if(entity != null ? !entity.equals(j4CEntity.entity) : j4CEntity.entity != null)
      return false;
    return jpql != null ? jpql.equals(j4CEntity.jpql) : j4CEntity.jpql == null;
  }
  
  @Override
  public int hashCode() {
    int result = entity != null ? entity.hashCode() : 0;
    result = 31 * result + (jpql != null ? jpql.hashCode() : 0);
    return result;
  }
  
  @Override
  public J4CEntity clone() {
    try {
      return (J4CEntity)super.clone();
    }
    catch(CloneNotSupportedException e) {
      throw new RuntimeException(e);
    }
  }
  
}
