/*
 * Decompiled with CFR 0.152.
 */
package cronapp.reports.j4c.dataset;

import cronapp.reports.j4c.dataset.J4CTable;
import cronapp.reports.j4c.dataset.jdbc.JDBC;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class J4CColumn
implements Serializable,
Cloneable {
    private J4CTable parent;
    private String name;
    private String as;
    private String type;

    public J4CColumn() {
    }

    public J4CColumn(J4CTable parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public J4CColumn(J4CTable parent, String name, String type) {
        this.parent = parent;
        this.name = name;
        this.type = type;
    }

    public J4CColumn(J4CTable parent, String name, String as, String type) {
        this.parent = parent;
        this.name = name;
        this.as = as;
        this.type = type;
    }

    public J4CColumn(String name, String as, String type) {
        this.name = name;
        this.as = as;
        this.type = type;
    }

    public J4CTable getParent() {
        return this.parent;
    }

    public void setParent(J4CTable parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAs() {
        return this.as;
    }

    public void setAs(String as) {
        this.as = as;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeJava() {
        return JDBC.getJavaType(this.type);
    }

    public Class<?> getTypeClass() {
        switch (this.type) {
            case "java.lang.Boolean": {
                return Boolean.class;
            }
            case "java.lang.Short": {
                return Short.class;
            }
            case "java.lang.Integer": {
                return Integer.class;
            }
            case "java.lang.Long": {
                return Long.class;
            }
            case "java.lang.Float": {
                return Float.class;
            }
            case "java.lang.Double": {
                return Double.class;
            }
            case "java.sql.Timestamp": {
                return Timestamp.class;
            }
            case "java.sql.Time": {
                return Time.class;
            }
            case "java.sql.Date": {
                return Date.class;
            }
            case "java.lang.String": {
                return String.class;
            }
        }
        return Object.class;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        J4CColumn j4CColumn = (J4CColumn)o;
        if (this.parent != null ? !this.parent.equals(j4CColumn.parent) : j4CColumn.parent != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(j4CColumn.name) : j4CColumn.name != null) {
            return false;
        }
        if (this.as != null ? !this.as.equals(j4CColumn.as) : j4CColumn.as != null) {
            return false;
        }
        return this.type != null ? this.type.equals(j4CColumn.type) : j4CColumn.type == null;
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.as != null ? this.as.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "J4CColumn{parent=" + this.parent + ", name='" + this.name + '\'' + ", as='" + this.as + '\'' + ", type='" + this.type + '\'' + '}';
    }

    public J4CColumn clone() {
        try {
            return (J4CColumn)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

