package cronapp.framework.persistence;

import org.passay.HistoryRule;
import org.passay.PasswordData;

public class PasswordHistoryRule extends HistoryRule {

  @Override
  protected boolean matches(String password, PasswordData.Reference reference) {
    var referencePassword = reference.getPassword();

    if (PasswordEncoder.getPasswordEncoder().isEncoded(referencePassword)) {
      return PasswordEncoder.getPasswordEncoder().matches(password, reference.getPassword());
    }

    return false;
  }
}
