package cronapp.framework.persistence;

import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

import java.util.regex.Pattern;

public final class PasswordEncoder {

  private final Pattern bcryptPattern = Pattern.compile("\\A\\$2a?\\$\\d\\d\\$[./0-9A-Za-z]{53}");
  private final BCryptPasswordEncoder bcryptEncoder = new BCryptPasswordEncoder();

  private PasswordEncoder() {

  }

  public boolean isEncoded(String s) {
    return bcryptPattern.matcher(s).matches();
  }

  public String encode(String rawPassword) {
    if (isEncoded(rawPassword)) {
      return rawPassword;
    }

    return bcryptEncoder.encode(rawPassword);
  }

  public boolean matches(String rawPassword, String encodedPassword) {
    return bcryptEncoder.matches(rawPassword, encodedPassword);
  }

  private static class PasswordEncoderHolder {
    private static final PasswordEncoder INSTANCE = new PasswordEncoder();
  }

  public static PasswordEncoder getPasswordEncoder() {
    return PasswordEncoderHolder.INSTANCE;
  }
}
