package cronapp.framework.authentication.social;

import com.google.gson.JsonObject;
import cronapi.ErrorResponse;
import cronapi.RestClient;
import cronapi.util.ReflectionUtils;
import cronapp.framework.authentication.token.AuthenticationController;
import cronapp.framework.authentication.token.AuthenticationResponse;
import cronapp.framework.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.UserProfileBuilder;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.facebook.api.impl.FacebookTemplate;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Collections;

@RestController()
public class SocialRESTAdapter {

  private static final Logger logger = LoggerFactory.getLogger(SocialRESTAdapter.class);

  @Autowired
  private ConnectionFactoryLocator connectionFactoryLocator;
  @Autowired
  private AuthenticationController authenticationController;
  @Autowired
  private HttpServletRequest servletRequest;

  @ExceptionHandler(Throwable.class)
  @ResponseBody
  ResponseEntity<ErrorResponse> handleControllerException(HttpServletRequest req, Throwable ex) {
    logger.error(ex.getMessage(), ex);
    ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), ex, req.getMethod());
    return new ResponseEntity<>(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
  }

  @RequestMapping(value = "/signin/facebook/", method = RequestMethod.GET)
  @ResponseBody
  public String postFacebook() {
    return "<body onload='document.facebook.submit()'><form action='/signin/facebook' method='POST' name='facebook'><input type='hidden' name='scope' value='email,public_profile'></form></body>";
  }

  @RequestMapping(value = "/signin/github/", method = RequestMethod.GET)
  @ResponseBody
  public String postGithub() {
    return "<body onload='document.github.submit()'><form action='/signin/github' method='POST' name='github'><input type='hidden' name='scope' value='email,public_profile'></form></body>";
  }

  @RequestMapping(value = "/signin/google/", method = RequestMethod.GET)
  @ResponseBody
  public String postGoogle() {
    return "<body onload='document.google.submit()'><form action='/signin/google' method='POST' name='google'><input type='hidden' name='scope' value='email'></form></body>";
  }

  @RequestMapping(value = "/auth/{providerId}/sso", method = RequestMethod.POST)
  public ResponseEntity<AuthenticationResponse> oauth2Callback(@PathVariable String providerId, @RequestParam(name = "client_id") String client_id, @RequestParam(name = "client_secret") String client_secret, @RequestParam(name = "access_token") String access_token) throws AuthenticationException {
    //TODO: Ainda precisa implementar Cronapp e Linkedin. Avaliar se essa implementação é necessária. Mantida, para avaliação.
    if (!SocialConfig.getProperties().getProperty("apiAuth", "").equals("true")) {
      throw new AuthenticationServiceException(Messages.getString("AuthError", "Not Authorized"));
    }

    var connectionFactory = (OAuth2ConnectionFactory<?>) connectionFactoryLocator.getConnectionFactory(providerId);

    var providerClientId = ReflectionUtils.getField(connectionFactory.getOAuthOperations(), "clientId");
    var providerClientSecret = ReflectionUtils.getField(connectionFactory.getOAuthOperations(), "clientSecret");

    if (!providerClientId.equals(client_id) || !providerClientSecret.equals(client_secret)) {
      throw new AuthenticationServiceException(Messages.getString("AuthError", "Not Authorized"));
    }

    UserProfile userProfile;
    String profileImage;
    if (providerId.equals("facebook")) {
      var facebook = new FacebookTemplate(access_token);
      var profile = facebook.userOperations().getUserProfile();
      profileImage = null;
      userProfile = new UserProfileBuilder().setId(profile.getId()).setName(profile.getName()).setFirstName(profile.getFirstName()).setLastName(profile.getLastName()).
          setEmail(profile.getEmail()).build();
    } else {
      var data = new ConnectionData(providerId, null, null, null, null, access_token, null, null, Long.MAX_VALUE);
      var connection = connectionFactory.createConnection(data);
      profileImage = connection.getImageUrl();
      userProfile = connection.fetchUserProfile();
    }

    var email = userProfile.getEmail();

    if (email == null) {
      email = userProfile.getUsername();
    }

    JsonObject json = new JsonObject();
    json.addProperty("name", userProfile.getName());
    json.addProperty("image", profileImage);

    var auth = new UsernamePasswordAuthenticationToken(email, providerId, Collections.singletonList(new SimpleGrantedAuthority("#OAUTH#")));

    auth.setDetails(json);

    RestClient.getRestClient().getRequest().setAttribute("CronappToken:SSOAccessToken", access_token);

    var deviceResolver = new LiteDeviceResolver();

    return authenticationController.auth(email, providerId, deviceResolver.resolveDevice(servletRequest), providerId, null, json, servletRequest);
  }

}

