package cronapp.framework.authentication.social;

import org.apache.commons.lang3.StringUtils;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionSignUp;
import org.springframework.stereotype.Service;

import java.util.UUID;

@Service
public class SocialConnectionSignup implements ConnectionSignUp {

  @Override
  public String execute(Connection<?> connection) {
    if (connection.getKey() != null && !StringUtils.isBlank(connection.getKey().getProviderUserId())) {
      return connection.getKey().getProviderUserId();
    }
    if (!StringUtils.isBlank(connection.getDisplayName())) {
      return connection.getDisplayName();
    }
    return UUID.randomUUID().toString();
  }
}