package cronapp.framework.authentication.security;

import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class CronappWebMvcConfigurer implements WebMvcConfigurer {
    @Override
    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/").setViewName("forward:/index.html");
        registry.addViewController("/mobileapp/").setViewName("forward:/mobileapp/index.html");
        registry.addRedirectViewController("/mobileapp", "/mobileapp/")
                .setKeepQueryParams(true)
                .setStatusCode(HttpStatus.MOVED_PERMANENTLY);
    }
}
