package cronapp.framework.authentication.social.linkedin;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class LinkedinProfileTemplate {

  @JsonProperty("id")
  private String id;
  private String emailAddress;
  @JsonProperty("localizedFirstName")
  private String firstName;
  @JsonProperty("localizedLastName")
  private String lastName;

  @JsonProperty("elements")
  private void unpackEmailFromNestedObject(List<Map<String, Object>> elements) {
    elements.forEach(element -> {
      emailAddress = ((Map<String, String>) element.get("handle~")).get("emailAddress");
    });

  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public String getEmailAddress() {
    return emailAddress;
  }

  public void setEmailAddress(String emailAddress) {
    this.emailAddress = emailAddress;
  }

  public String getFirstName() {
    return firstName;
  }

  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }

  public String getLastName() {
    return lastName;
  }

  public void setLastName(String lastName) {
    this.lastName = lastName;
  }
}


