package cronapp.framework.rest;

import cronapp.framework.api.ApiManager;
import cronapp.framework.api.Device;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/device")
public class UpdateDevice {

    @ResponseStatus(HttpStatus.OK)
    @RequestMapping(method = RequestMethod.POST)
    public void post(Device device) throws Exception {
        if (device.getId() != null & device.getToken() != null) {
            ApiManager.updateDevice(device);
        }
    }
}