package cronapp.framework.authentication.external;

import cronapi.AppConfig;
import cronapp.framework.i18n.Messages;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;

class LdapAuthenticator extends BasedInLdapAuthenticator {

  @Override
  public Authentication authenticate(Authentication authentication) throws AuthenticationException {
    Assert.isInstanceOf(UsernamePasswordAuthenticationToken.class, authentication, "Only UsernamePasswordAuthenticationToken is supported");

    final UsernamePasswordAuthenticationToken userToken = (UsernamePasswordAuthenticationToken) authentication;
    String principal = "uid=" + userToken.getPrincipal().toString() + ',' + AppConfig.defaultDomain();

    if (super.authenticate(generateProviderUrl(), principal, userToken.getCredentials().toString())) {
      return authentication;
    }

    throw new BadCredentialsException(Messages.getString("UserOrPassordInvalids"));
  }
}
