package cronapp.framework.authentication.social;

import java.net.URLEncoder;
import java.util.Arrays;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import br.com.techne.cronapp.acesso.AcessoService;
import cronapi.ErrorResponse;
import cronapp.framework.authentication.normal.AuthenticationConfigurer;
import cronapp.framework.i18n.Messages;
import org.springframework.mobile.device.DeviceResolver;
import org.springframework.mobile.device.LiteDeviceResolver;
import cronapp.framework.authentication.token.AuthenticationResponse;
import cronapp.framework.authentication.token.AuthenticationController;

/**
 * Controller responsável por gerir a troca de
 * senha do usuário através de serviço REST
 *
 * @author Techne
 */
@RestController
@RequestMapping(value = "/signin/cronapp")
public class CronappSign {
  
  public static final String HTTPS_ACESSO_CRONAPP_IO = "https://acesso.cronapp.io";
  @Autowired
  private HttpServletRequest request;
  
  @Autowired
  private HttpServletResponse response;
  
  @Autowired(required = false)
  private AuthenticationConfigurer authenticationConfigurer;
  
  @Autowired(required = false)
  private AuthenticationController authenticationController;
  
  @ExceptionHandler(Throwable.class)
  @ResponseBody
  ResponseEntity<ErrorResponse> handleControllerException(HttpServletRequest req, Throwable ex) {
    ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), ex, req.getMethod());
    return new ResponseEntity<ErrorResponse>(errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
  }
  
  @ResponseStatus(HttpStatus.OK)
  @RequestMapping(method = RequestMethod.GET)
  public void get(@RequestParam(name = "_ctk") String ctk) throws Exception {
    if(!SocialConfig.isEnabled("cronapp"))
      throw new Exception(Messages.getString("notAllowed"));
    
    AcessoService acesso = new AcessoService(HTTPS_ACESSO_CRONAPP_IO, "", "");
    acesso.validaToken(ctk);
    String json = acesso.getUserInfo(ctk);
    Gson gson = new Gson();
    JsonElement elem = gson.fromJson(json, JsonElement.class);
    String email = elem.getAsJsonObject().get("email").getAsString();
    String name = elem.getAsJsonObject().get("given_name").getAsString();
    String lastname = elem.getAsJsonObject().get("family_name").getAsString();
    
    JsonObject details = new JsonObject();
    details.addProperty("name", (name + " " + lastname).trim());
    
    UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken(email, "cronapp",
            Arrays.asList(new SimpleGrantedAuthority("#OAUTH#")));
    auth.setDetails(details);
    
    String redirect = request.getContextPath() + "/#/connected";
    
    if(authenticationConfigurer != null) {
      authenticationConfigurer.authenticate(auth);
      
      SecurityContextHolder.getContext().setAuthentication(auth);
      
      try {
        request.getSession().setAttribute("#OAUTH#USER", email);
      }
      catch(Exception e) {
        e.printStackTrace();
      }
      
    }
    else {
      DeviceResolver deviceResolver = new LiteDeviceResolver();
      
      ResponseEntity<AuthenticationResponse> authenticationRequest = authenticationController.auth(email, "cronapp",
              deviceResolver.resolveDevice(request), "cronapp", null, details,null);
      
      redirect = request.getContextPath() + "/#/connected?_ctk=" + authenticationRequest.getBody().getToken();
    }
    
    response.sendRedirect(redirect);
  }
  
  @ResponseStatus(HttpStatus.OK)
  @RequestMapping(method = RequestMethod.POST)
  public void post() throws Exception {
    if(!SocialConfig.isEnabled("cronapp"))
      throw new Exception(Messages.getString("notAllowed"));
    
    response.sendRedirect(HTTPS_ACESSO_CRONAPP_IO + "/#/?redirect_url=" +
            URLEncoder.encode(request.getRequestURL().toString(), cronapi.CronapiConfigurator.ENCODING));
  }
}
